<?php
/**
 * Defines the RawapiGetCountriesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets a list of all countries with the ISO 3166 code mapped to the countries name. This method will attempt
 * translation of it's returned objects, where available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCountriesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCountriesRequest.
 */
abstract class RawapiGetCountriesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCountries';

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
