<?php
use Red61\Via\DataObject\ViaApiPerformance;
use Red61\Via\DataObject\ViaApiPriceConcession;
use Red61\Via\DataObject\ViaApiPurchaseSummary;
use Red61\Via\RawGenerated\DataObject\ViaApiSchemeTierDetails;
use Red61\Via\RawGenerated\DataObject\ViaApiTicketDetails;

/**
 * @param Red61_Via $via
 * @param ViaApiPerformance[] $performances
 */
function displayPerfCalendars($via,$performances)
{
	if(empty($performances)) {
		print "No Performances\n";
	}
	else {
		$prices = getGroupedPrices($via,$performances);
		foreach($via->groupPerformancesByDate($performances) as $perfs_month) {
			_renderCalendar($perfs_month,$prices);
		}
	}
}

/**
 * @param Red61_Via           $via
 * @param ViaApiPerformance[] $performances
 * @param string              $conc_code
 *
 * @return array
 */
function getGroupedPrices($via,$performances,$conc_code="CO")
{
	$prices = array();
	if(!is_array($performances)){
		$performances = array();
	}
	foreach($performances as $perf) {
		/** @var ViaApiPerformance $perf */
		$pc_desc = "";
		if(isset($perf->concessions)) {
			$concessionTitles = array();
			foreach($perf->concessions as $concession){
				$concessionTitles[] = $concession->title;
			}
			$pc_title = implode($concessionTitles,", ");
			$key = $perf->maxfullprice . ", " . $pc_title;
		}else {
			$key = $perf->maxfullprice;
			$pc_title = "";
		}
		if(!isset($prices[$key])) {
			$perfprices = $via->getPerformancePrices($perf->id);
			$fullprice = null;
			$concession = null;
			foreach($perfprices as $price) {
				if(($fullprice == null)||($price->price < $fullprice)) {
					$fullprice = $price->price;
					if(isset($price->concessions)){
						if(!is_array($price->concessions)) $price->concessions = array($price->concessions);
						foreach($price->concessions as $conc) {
							/** @var ViaApiPriceConcession $conc */
							if(isset($conc->code) && ($conc->code == $conc_code)) {
								$concession = $conc->concPrice;
							}
						}
					}
				}
			}
			$prices[$key] = array('fp'=>$fullprice,'conc'=>$concession,'pc'=>$pc_title,'pc_desc'=>$pc_desc);
		}
	}
	return($prices);
}

/**
 * @param Red61_Via           $via
 * @param ViaApiPerformance[] $performances
 * @param string              $conc_code
 */
function displayPriceKey($via,$performances,$conc_code="CO")
{
	global $price_colours, $currency_h;
	$prices = getGroupedPrices($via,$performances,$conc_code);
	print "<table>";
	$i = 0;
	foreach($prices as $price) {
		print "<tr><td style=\"background: ".$price_colours[$i].";\">&nbsp;</td>";
		print "<td>$currency_h &nbsp;" . $price['fp'];
		if($price['conc']) print "&nbsp;($currency_h&nbsp;" . $price['conc'].")";
		if($price['pc']) {
			print "&nbsp;" . $price['pc'];
		}
		print "</td></tr>";
		$i++;
	}
	print "</table>";
}

/**
 * @param array $performances performances grouped by month and day
 * @param array $prices
 */
function _renderCalendar($performances,$prices)
{
	global $price_colours, $CFG;
	//print_r($performances);
	$days = array("Mon","Tue","Wed","Thu","Fri","Sat","Sun");
	// timestamp of first performance of first day
	$first_perf = strtotime($performances[array_shift(array_keys($performances))][0]->datetime) - (6 * 60 * 60);
	// timestamp of first performance of last day
	$last_perf = strtotime($performances[array_pop(array_keys($performances))][0]->datetime)- (6 * 60 * 60) +1;

	print "<p><h2>" . date("F",$first_perf) . "</h2></p>\n";
	print '<div>';
	print "<table id=\"perfdateblock\">\n";
	print "<tr><th>" . implode("</th><th>",$days) . "</th></tr>\n";
	$days = array_flip($days);
	print "<tr>\n";
	$d = 0;
	// pad starting days to get to the right day of the week
	for($i=0;$i < $days[date("D",$first_perf)]; $i++) {
		print "\t<td>&nbsp;</td>\n";
		$d++;
	}
	$day=strtotime(date("Y-m-d 00:00:01",$first_perf));
	while($day <= $last_perf) {
		$day_index=date("d",$day);
		#print_r($perf);
		if(isset($performances[$day_index])) {
			if(count($performances[$day_index]) > 1) {
				print "\t<td>";
				print date("j",$day) . "<br>\n";
				foreach($performances[$day_index] as $perf) {
					/** @var ViaApiPerformance $perf */
					if(isset($CFG['time_display_format'])){
						print "<div style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title'>" . date($CFG['time_display_format'],strtotime($perf->datetime)) . "</div></a>\n";
					}else{
						print "<div style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title'>" . date('H:i',strtotime($perf->datetime)) . "</div></a>\n";
					}
				}
			}
			else {
				$perf = $performances[$day_index][0];
				/** @var ViaApiPerformance $perf */
				if(isset($CFG['time_display_format'])){
					print "\t<td style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title ". date($CFG['time_display_format'],strtotime($perf->datetime)) . "'>" . date("j",$day) . "</a>\n";
				}else{
					print "\t<td style=\"background: ".getPriceColorFromPerf($perf,$prices).";\"><a href='listprices.php?performanceId=$perf->id' title='$perf->title ". date('H:i',strtotime($perf->datetime)) . "'>" . date("j",$day) . "</a>\n";
				}
			}
		}
		else {
			print "\t<td class='noshow'>&nbsp;";
		}
		print "</td>\n";
		$d++;
		if($d > 6) {
			print "</tr>\n<tr>";
			$d=0;
		}
		$day = strtotime("+1 day", $day);
	}
	// pad starting days to get to end the week
	if($d != 0) {
		for($i=$d;$i <= 6; $i++) {
			print "\t<td>&nbsp;</td>\n";
			$d++;
		}
	}
	print "</tr>\n";
	print "</table></div>\n";
}

/**
 * @param ViaApiPerformance $perf
 * @param array             $prices
 *
 * @return string
 */
function getPriceColorFromPerf($perf,$prices)
{
	global $price_colours;
	if(isset($perf->concessions)) {
		$titles = array();
		foreach($perf->concessions as $concession){
			$titles[] = $concession->title;
		}
		$key = $perf->maxfullprice . ", " . implode($titles,", ");
	}
	else {
		$key = $perf->maxfullprice;
	}
	return($price_colours[array_search($key,array_keys($prices))]);
}

/**
 * @param ViaApiPurchaseSummary $summary
 */
function displayOrderSummaryHTML($summary)
{
	global $currency_h, $CFG;
	?>
	<table>
	<tr>
		<th>Customer Details</th>
		<td><?php echo $summary->customername ?></td>
	</tr>
	<tr>
		<th>Date</th>
		<td><?php 
			if(isset($CFG['date_display_format'])){
				echo date( $CFG['date_display_format'].' '.$CFG['time_display_format'], strtotime($summary->date)) ;
			}else{
				echo $summary->date;
			}
			?></td>
	</tr>
	<tr>
		<th>Transaction ID</th>
		<td><?php echo $summary->orderid ?></td>
	</tr>
	<tr>
		<th>Transaction Ref</th>
		<td><?php echo $summary->ordertitle ?></td>
	</tr>
	<?php
	if(isset($summary->products) && count($summary->products) > 0){
		$ticketsCount = 0;
		foreach($summary->products as $product) {
			if(isset($product)){
				$ticketsCount += $product->quantity;
			}
		}
		if($ticketsCount > 0){
			?>
			<tr>
				<th valign="top">Tickets Purchased (<?php echo $ticketsCount?>)</th>
				<td>
					<table>
						<tr>
							<th>Event</th>
							<th>Qty</th>
							<th>Item</th>
							<?php if(DISPLAY_BARCODE) { ?><th>Barcode</th><?php } ?>
						</tr>
						<?php
						displayTickets($summary->products);
						?>
					</table>
				</td>
			</tr>
		<?php
		}
	}
	?>

	<?php
	if(isset($summary->schemes)){
		?>
		<tr>
			<th style="vertical-align: top">Schemes Purchased (<?php echo count($summary->schemes)?>)</th>
			<td>
				<table>
					<tr>
						<th>Scheme</th><th>Level</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->schemes)) {
						$schemes = array($summary->schemes);
					}
					else {
						$schemes = $summary->schemes;
					}
					foreach($schemes as $scheme){
						?>
						<tr>
							<td><?php echo $scheme->title ?> </td>
							<td><?php echo $scheme->tierTitle ?>
								<?php
								if(isset($scheme->concessions[0])) {
									print " - " . $scheme->concessions[0]->title;
								}
								?>
							</td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $scheme->fee) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>
	<?php
	if(isset($summary->merchandise)){
		?>

		<tr>
			<th style="vertical-align: top">Merchandise Purchased (<?php echo count($summary->merchandise)?>)</th>
			<td>
				<table>
					<tr>
						<th>Merchandise</th><th>Quantity</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->merchandise)) {
						$merchandiseArr = array($summary->merchandise);
					}
					else {
						$merchandiseArr = $summary->merchandise;
					}
					foreach($merchandiseArr as $merchandise){
						$varTitle = $merchandise->variationTitle;
						if(!$merchandise->defaultVariation){
							$varTitle = $merchandise->merchandiseTitle . " - " . $varTitle;
						}
						?>
						<tr>
							<td><?php echo $varTitle ?> </td>
							<td><?php echo $merchandise->quantity ?> </td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $merchandise->value) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>

	<?php
	if(isset($summary->vouchers)){
		?>

		<tr>
			<th style="vertical-align: top">Vouchers Purchased (<?php echo count($summary->vouchers)?>)</th>
			<td>
				<table>
					<tr>
						<th>Voucher</th><th>Price</th>
					</tr>
					<?php
					if(!is_array($summary->vouchers)) {
						$vouchers = array($summary->vouchers);
					}
					else {
						$vouchers = $summary->vouchers;
					}
					foreach($vouchers as $voucher){
						?>
						<tr>
							<td><?php echo $voucher->title ?> </td>
							<td><?php echo $currency_h ?>&nbsp;<?php printf("%01.2f", $voucher->credit) ?></td>
						</tr>
					<?php
					}
					?>
				</table>
		</tr>
	<?php
	}
	?>

	<?php
	if(isset($summary->donations)){ ?>
		<tr><th style="vertical-align: top">Donations:</th></tr>
		<?php foreach ($summary->donations as $i=>$donation) {
			$ga= "Non gift aid";
			if($donation->giftaid){
				$ga = "Gift Aid";
			}
			?>
			<tr>
				<td><?php echo $donation->title ?></td>
				<td><?php echo $currency_h?>&nbsp;<?php printf("%01.2f", $donation->amount); printf(" ".$ga)?></td>
			</tr>
		<?php
		}
	}
	?>

	<tr>
		<th>SubTotal</th>
		<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->subtotal ?></td>
	</tr>
	<?php if($summary->orderFee > 0) { ?>
		<tr>
			<th>Handling Fee</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->orderFee ?></td>
		</tr>
	<?php } ?>
	<?php if($summary->postagefee > 0) { ?>
		<tr>
			<th>Postage Fee</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->postagefee ?></td>
		</tr>
	<?php } ?>
	<?php if($summary->discount < 0) { ?>
		<tr>
			<th>Discounts</th>
			<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->discount ?></td>
		</tr>
	<?php } ?>
	<tr>
		<th>Total</th>
		<td><?php echo $currency_h ?>&nbsp;<?php echo $summary->total ?></td>
	</tr>
	</table>
	<?php if(DISPLAY_BARCODE) { ?>
	<h2>eTicket</h2>
	<img src="<?php echo $summary->barcodeURL ?>"/>
<?php } ?>
	<?php
	google_ecommerce($summary);

}

/**
 * @param ViaApiPurchaseSummary $summary
 */
function displayReservationSummaryHTML($summary){
	?>
	<table>
		<tr>
			<th>Customer Details</th>
			<td><?php echo $summary->customername ?></td>
		</tr>
		<tr>
			<th>Date</th>
			<td><?php echo $summary->date ?></td>
		</tr>
		<tr>
			<th>Transaction ID</th>
			<td><?php echo $summary->orderid ?></td>
		</tr>
		<tr>
			<th>Transaction Ref</th>
			<td><?php echo $summary->ordertitle ?></td>
		</tr>
		<?php
		if(isset($summary->products) && count($summary->products) > 0){
			$ticketsCount = 0;
			foreach($summary->products as $product) {
				if(isset($product)){
					$ticketsCount += $product->quantity;
				}
			}
			if($ticketsCount > 0){
				?>
				<tr>
					<th>Tickets Reserved (<?php echo $ticketsCount?>)</th>
					<td>
						<table>
							<tr>
								<th>Event</th>
								<th>Qty</th>
								<th>Item</th>
							</tr>
							<?php
							displayTickets($summary->products);
							?>
						</table>
					</td>
				</tr>
			<?php
			}
		}
		?>
	</table>
<?php
}

/**
 * @param ViaApiTicketDetails[] $products
 */
function displayTickets($products){
	if(!is_array($products)) {
		$products = array($products);
	}
	foreach($products as $product) {
		/** @var ViaApiTicketDetails $product */
		?>
		<tr valign="top">
			<td valign="top"><?php echo $product->event ?> @ <?php echo $product->venue ?> in <?php echo $product->subvenue ?> @ <?php echo apply30HourRule($product->date) ?></td>
			<td valign="top"><?php echo $product->quantity ?></td>
			<td valign="top"><?php echo $product->pricebandconcession ?><?php if($product->performanceconcession) print " - " . $product->performanceconcession; ?><?php if($product->reserved) print " <br>[".$product->area." ".$product->block." ".$product->row.$product->seat."]"; ?></td>
			<?php if(DISPLAY_BARCODE) { ?>
				<td valign="top"><?php
					foreach($product->ticketItems as $ticketItem) {
						$barcode = $ticketItem->barcode;
						print "<img src=\"barcode.php?code=$barcode\" /><br/>";
					}
					?>
				</td>
			<?php } ?>
		</tr>
	<?php }
}


/**
 * @param ViaApiPurchaseSummary $summary
 *
 * @return string
 */
function getEmailSummary($summary)
{
	// arrg, bloody soap
	if(isset($summary->products)){
		if(!is_array($summary->products)) {
			$products = array($summary->products);
		}
		else {
			$products = $summary->products;
		}
	}else{
		$products = array();
	}
	if(isset($summary->schemes)){
		if(!is_array($summary->schemes)) {
			$schemes = array($summary->schemes);
		}else{
			$schemes = $summary->schemes;
		}
	}else{
		$schemes = array();
	}
	$string = "";
	$string .= "Customer Details: $summary->customername\n";
	$string .= "Date: $summary->date\n";
	$string .= "Transaction ID: $summary->orderid\n";
	$string .= "Transaction Ref: $summary->ordertitle\n";
	if(count($products) > 0){
		$ticketsCount = 0;
		foreach($products as $product) {
			/** @var ViaApiTicketDetails $product */
			$ticketsCount += $product->quantity;
		}
		$string .= "Tickets Purchased: ($ticketsCount)\n";

		if($summary->post == 0) {
			$string .="\n\nPresent your Transaction ID at the Box Office to collect your tickets\n\n";
		} else {
			$string .= "\n\nYour tickets will be posted out to the address you supplied\n\n";
		}
		foreach($products as $product) {
			$string .= "\t$product->event @ $product->venue in $product->subvenue @ " . apply30HourRule($product->date) . " ";
			$string .= "$product->quantity x ";
			$ticketsAmount = $product->quantity * $product->price;
			if($product->priceband != "Price band 1") $string .= $product->priceband . " - ";
			$string .= "$product->pricebandconcession";
			if($product->performanceconcession) {
				$string .= " - $product->performanceconcession";
			}
			$string .= " $currency_p$product->price = $currency_p$ticketsAmount";
			if($product->reserved) $string .= " [".$product->block." ".$product->row.$product->seat."]";
			$string .= " $product->boughtUnderScheme";
			$string .= "\n";

		}
		$string .= "\n";
	}

	if(count($schemes > 0)){
		$string .= "Subscriptions Purchased: (". count($schemes).")\n";
		foreach($schemes as $scheme){
			$string .= "\t".$scheme->title." $currency_p".$scheme->fee . "\n";
		}
	}
	$string .="\nSubTotal: $currency_p $summary->subtotal\n";
	$string .= "Fees: $currency_p $summary->feeTotal\n";
	$string .= "Total: $currency_p $summary->total\n";

	return($string);
}

/**
 * Applies the Fringe "30 hour rule" to a date. This produces a string
 * that is suitable for display both in the GUI and on tickets.
 * <p>
 * The 30 hour rule stipulates that if a show starts between 00:00 and
 * 06:00 on a day <code>n</code>, then its date should be treated as
 * <code>n-1</code>. Thus a show at Sun 10 Aug 2008 01:00 should
 * use a date of "Sat 09 Aug 2008" 01:00. Note that quotes should
 * be included to emphasise that this is not the true date.
 *
 * @param mixed date the date to apply the rule to, either as a String or as a
 *        UNIX timestamp
 * @return string a string representation of <code>date</code> formattted
 *         according to the 30 hour rule.
 */
function apply30HourRule($date) {
	global $CFG;
	if (!is_numeric($date)) {
		$date = str_replace("24:","00:",$date);
		$unixtime = strtotime($date);
	} else {
		$unixtime = $date;
	}
#		if(!$unixtime) print "we are epoch [$date]";
	if (date('G', $unixtime) < 5) {
		// Apply rule
		$retDate = '"' . date('D d M Y', $unixtime - (24 * 60 * 60)) . '"';
	} else {
		// Don't apply
		$retDate = date('D d M Y', $unixtime);
	}
	//return $retDate . ' ' . date('H:i', $unixtime);
	if(isset($CFG['time_display_format'])){
		return $retDate . ' ' . date($CFG['time_display_format'], $unixtime);
	}else{
		return $retDate . ' ' . date('H:i', $unixtime);
	}
}

function createQRUrl($id,$ref) {
	return("http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/qr_img.php?id=" . urlencode($id) . "&ref=" . urlencode($ref));
}

/**
 * @param ViaApiSchemeTierDetails $st
 *
 * @return string
 */
function scheme_benefits_explaination($st)
{
	$msg = "You may purchase discounted tickets for ";
	if($st->performanceEventLimit) {
		$msg .= $st->performanceEventLimit;
	}
	else {
		$msg .= "an unlimited";
	}
	$msg .= " number of " . $st->maxCountContext . "s";
	if($st->maxPerPerformanceEvent) {
		$msg .= ", with a maximum of " . $st->maxPerPerformanceEvent . " tickets in any given performance";
	}
	return($msg);
}

/**
 * @param ViaApiPurchaseSummary $summary
 */
function google_ecommerce($summary) {

	global $currency_code;

	//Should see request for _utm.gif in network requests
	if(!defined('GOOGLE_UA')) return;
	?>
<script type="text/javascript">

  var _gaq = _gaq || [];
  _gaq.push(['_setAccount', '<?php echo GOOGLE_UA ?>']);
  _gaq.push(['_trackPageview']);
  _gaq.push(['_addTrans',
    '<?php echo $summary->orderid ?>',
    '<?php echo $_SERVER['HTTP_HOST'] ?>',
    '<?php echo $summary->total ?>',
    '0.00', // tax
    '<?php echo $summary->postagefee ?>',
    'City',
    'State',
    'Country'
  ]);
  <?php

	$transaction_id = $summary->orderid;

	/*
	 * Array to store products to be pushed to GA
	 * Takes the form:
	 * key  = eventid|performanceid|variation -
	 * value = object (title, price, quantity)
	 */
	$output_items = array();
	/*
	 * Loop through products collating the quantities for similar items
	 * into array $output_items - then loop through $output_items
	 * to send each item to the GA server
	 */
	foreach($summary->products as $product) {
		//Product is actually viaApiTicketDetails object
		//Unescaped apostrophes and quotations break the ga.js script
		$product_title = str_replace("'","\'",$product->event);
		$product_title = str_replace('"',"\'",$product_title);
		//Get the event id typically 33:2345
		$event_id = $product->eventId;
		//Get the performance id - typically 33:4683567
		$performance_id = $product->performanceId;
		$product_variation =  $product->priceband;
		if($product->performanceconcession){
			 $product_variation .= " - " . $product->performanceconcession;
		 }else{
			 $product_variation .= " - " . $product->pricebandconcession;
		 }
		$price = $product->price;
		$quantity = $product->quantity;
		/*
		 * The products may come from different server
		 */
		$sku_separator = '|';
		$sku = $event_id.$sku_separator.$performance_id.$sku_separator.$product_variation;
		/*
		 * Here we collate similar items so that we can increment the quantity
		 * A similar item has the same SKU
		 * If the existing SKU not found in the array of objects then
		 * add a new object
		 */
		if (array_key_exists($sku, $output_items)) {
			$existing_obj = $output_items[$sku];
			//Add new quantity to existing
			$new_quantity = $existing_obj->quantity + $quantity;
			$existing_obj->quantity = $new_quantity;
			$output_items[$sku] = $existing_obj;
		}else{
			$obj = new stdClass;
			$obj->title = $product_title;
			$obj->price = $price;
			$obj->quantity = $quantity;
			$output_items[$sku] = $obj;
		}
	 }

	 //Now add the items to GA
	 foreach($output_items as $key => $x_obj) {
		 list ($x_event_id,$x_performance_id,$x_product_variation) = explode($sku_separator, $key);
		  ?>
		_gaq.push(['_addItem',
				'<?php echo $transaction_id ?>',
				'<?php echo $key ?>',
				'<?php echo $x_obj->title ?>',
				'<?php echo $x_product_variation ?>',
				'<?php echo $x_obj->price ?>',
				'<?php echo $x_obj->quantity ?>'
			  ]);
			<?php
	 }

	 if(isset($currency_code) && (strlen($currency_code) == 3)) { ?>
		_gaq.push(['_set', 'currencyCode', '<?php echo $currency_code ?>']);
	<?php } ?>

  _gaq.push(['_trackTrans']); //submits transaction to the Analytics server

  (function() {
    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
  })();

</script>
	<?php
}

function create3DSecurePOST($redirect) {

	$redirect = trim($redirect);
	$urlArray = parse_url($redirect);
	$pathAndQuery = $urlArray['path'];
	$post = array();
	$get = array(); // should never be query string in POST, but some ACSs are broken
	foreach(explode("&",$urlArray['query']) as $part) {
		if(preg_match("/([^=]+)=(.+)/",$part,$matches)) {
			$key = $matches[1];
			if(in_array($key, array('MD','PaReq','TermUrl','TransactionID'))) {
				$post[$key] = urldecode($matches[2]);
			}
			else {
				$get[$key] = $part;
			}
		}
	}
	if(count($get)) {
		$pathAndQuery .= "?" . implode("&", $get);
	}
	?>
	<html>
	<body onLoad="redirect();" >
	Redirecting to your banks website, please wait ...
	<?php
	print "<form name=\"downloadForm\" action=\"".$urlArray['scheme']."://".$urlArray['host'].$pathAndQuery."\" method=\"POST\">";

	foreach($post as $key=>$value) {
		print "<input type=\"hidden\" name=\"$key\" value=\"$value\"/>\n";
	}
	if(!isset($post['TermUrl'])) {
		print "<input type=\"hidden\" name=\"TermUrl\" value=\"http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF']."\">";
	}
	?>
	<input type="submit" value=">>"/>
	</form>
	<script language="Javascript" >
		<!--
		function redirect(){
			document.downloadForm.submit();
		}
		//-->
	</script>
	</body>
	</html>
<?php
}

/**
 * The following method takes the given events and then 
 * returns an orded list of the suggested similar events 
 * with the events with the most suggestions appearing 
 * sooner in the list.
 * @param red61_via $via
 * @param viaApiBasketEventItem $basketEvents events retrieved from the viaApiBasket object
 * @param int $relatedMultiplier multiplier value which can be 
 * used to increase or decrease the weight of related events. The higher an event's weight the
 * sooner it appears in the returned list.
 * @param int $suggestedMultiplier multiplier value which can be 
 * used to increase or decrease the weight of suggested events. The higher an event's weight the
 * sooner it appears in the returned list.
 * @param int $limit if limit is set to Zero then all suggested events will be returned, otherwise
 * the returned list will be populated with the "$limit" events with the highest weight.
 * @return array of viaApiEvent objects
 */
function getBasketEventSuggestions(red61_via $via, $basketEvents, $relatedMultiplier, $suggestedMultiplier, $limit) {
	$finalEventsList = array();

	$basketEventIds = array();
	foreach ($basketEvents as $basketEvent) {
		$basketEventIds[] = $basketEvent->eventid;
	}

	foreach ($basketEvents as $basketEvent) {

		$event = $via->getEventDetails($basketEvent->eventid);

		if (is_array($event->suggestedEvents)) {
			foreach ($event->suggestedEvents as $suggestedEvent) {
				if (!in_array($suggestedEvent->id, $basketEventIds)) {
					if (!isset($finalEventsList[$suggestedEvent->id])) {
						$finalEventsList[$suggestedEvent->id] = 0;
					}
					$finalEventsList[$suggestedEvent->id] += (1 * $suggestedMultiplier);
				}
			}
		}

		if (is_array($event->relatedEvents)) {
			foreach ($event->relatedEvents as $relatedEvent) {
				if (!in_array($relatedEvent->id, $basketEventIds)) {
					if (!isset($finalEventsList[$relatedEvent->id])) {
						$finalEventsList[$relatedEvent->id] = 0;
					}
					$finalEventsList[$relatedEvent->id] += (1 * $relatedMultiplier);
				}
			}
		}
	}

	arsort($finalEventsList);
	if ($limit > 0) {
		$finalEventsList = array_slice($finalEventsList, 0, $limit);
	}

	$eventDetails = array();
	foreach ($finalEventsList as $eventId=>$weight) {
		$eventDetails[] = $via->getEventDetails($eventId);
	}
	return $eventDetails;
}

	?>
