<?php
/**
 * Defines the RawViaApiProductDetails data object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents a group of similar tickets.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiProductDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiProductDetails.
 */
abstract class RawViaApiProductDetails {

  /**
   * The unit price of the ticket. This is the price before any concession discounts.
   *
   * @var string
   */
  protected $unitprice;

  /**
   * The final price of the ticket. This takes into account any concessions.
   *
   * @var string
   */
  protected $finalprice;

  /**
   * The price band that these tickets belong to.
   *
   * @var int
   */
  protected $pricebandid;

  /**
   * The reference of the performance these tickets are for.
   *
   * @var string
   */
  protected $performanceid;

  /**
   * The seat summary string for this group of tickets.
   * This string will only be populated if the reservation level is SEAT
   * and displays the seats within a row (e.g A1-A5, A8, A10, A11-A13)
   *
   * @var string
   */
  protected $seatSummaryString;

  /**
   * The area that this seat is in (reserved seating only).
   *
   * @var string
   */
  protected $area;

  /**
   * The block that this seat is in (reserved seating only).
   *
   * @var string
   */
  protected $block;

  /**
   * The row that this seat is in (reserved seating only).
   *
   * @var string
   */
  protected $row;

  /**
   * The id of the priceband concession applied to this ticket if any.
   *
   * @var int
   */
  protected $priceband_concessionid;

  /**
   * The number of tickets in the group.
   *
   * @var int
   */
  protected $quantity;

  /**
   * The total value of this ticket or ticket group. This is simply quantity * final price.
   *
   * @var string
   */
  protected $ticketstotal;

  /**
   * The price band name and concession title of this ticket/tickets.
   *
   * @var string
   */
  protected $ticketype;

  /**
   * A pipe delimited String of the ids of tickets in this group.
   *
   * @var string
   */
  protected $ticketids;

  /**
   * Whether this performance has reserved seating.
   *
   * @var bool
   */
  protected $reserved;

  /**
   * The list of ViaApiSeatDetails (seats) for this group of tickets.
   *
   * @var \Red61\Via\DataObject\ViaApiSeatDetails[]
   */
  protected $seats;

  /**
   * A user-friendly summary string for this group of tickets according to their reservation level.
   * Example for reservation level UNRESERVED/NONE: 10x Unreserved.
   * Example for reservation level AREA: 10x Area1.
   * Example for reservation level BLOCK: 10x Area1:Block1.
   * Example for reservation level ROW: 10x Area1:Block1:Row1
   * Example for reservation level SEAT: 10x Area1:Block1:A1-A5, A8, A10, A11-A13.
   *
   * @var string
   */
  protected $summaryLabel;

  /**
   * The reservation level for the price band these tickets belong to.
   *
   * @var string
   */
  protected $reservationLevel;

  /**
   * The id of this concession.
   *
   * @var int
   */
  protected $concessionid;

  /**
   * The code of the concession applied to this group of tickets.
   *
   * @var string
   */
  protected $concessionCode;

  /**
   * The price band title for this group of tickets.
   *
   * @var string
   */
  protected $pricebandTitle;

  /**
   * The title of the concession applied to this group of tickets.
   *
   * @var string
   */
  protected $concessionTitle;

  /**
   * The scope of this concession.
   * PB - Price Band	- A price band scoped concession.
   * PC - Peformance	- A performance scoped concession.
   * PBFP - Full Price - Full Price
   *
   * @var string
   */
  protected $scope;

  /**
   * Whether or not this group of tickets is eligible for gift aid.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable portion of this concession.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The value of the tax on this group of tickets
   *
   * @var string
   */
  protected $tax;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'unitprice':
        return $this->getUnitprice();
      case 'finalprice':
        return $this->getFinalprice();
      case 'pricebandid':
        return $this->getPricebandid();
      case 'performanceid':
        return $this->getPerformanceid();
      case 'seatSummaryString':
        return $this->getSeatSummaryString();
      case 'area':
        return $this->getArea();
      case 'block':
        return $this->getBlock();
      case 'row':
        return $this->getRow();
      case 'priceband_concessionid':
        return $this->getPriceband_concessionid();
      case 'quantity':
        return $this->getQuantity();
      case 'ticketstotal':
        return $this->getTicketstotal();
      case 'ticketype':
        return $this->getTicketype();
      case 'ticketids':
        return $this->getTicketids();
      case 'reserved':
        return $this->getReserved();
      case 'seats':
        return $this->getSeats();
      case 'summaryLabel':
        return $this->getSummaryLabel();
      case 'reservationLevel':
        return $this->getReservationLevel();
      case 'concessionid':
        return $this->getConcessionid();
      case 'concessionCode':
        return $this->getConcessionCode();
      case 'pricebandTitle':
        return $this->getPricebandTitle();
      case 'concessionTitle':
        return $this->getConcessionTitle();
      case 'scope':
        return $this->getScope();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'tax':
        return $this->getTax();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The unit price of the ticket. This is the price before any concession discounts.
   *
   * @return string
   */
  public function getUnitprice()
  {
    return $this->unitprice;
  }


  /**
   * The final price of the ticket. This takes into account any concessions.
   *
   * @return string
   */
  public function getFinalprice()
  {
    return $this->finalprice;
  }


  /**
   * The price band that these tickets belong to.
   *
   * @return int
   */
  public function getPricebandid()
  {
    return $this->pricebandid;
  }


  /**
   * The reference of the performance these tickets are for.
   *
   * @return string
   */
  public function getPerformanceid()
  {
    return $this->performanceid;
  }


  /**
   * The seat summary string for this group of tickets.
   * This string will only be populated if the reservation level is SEAT
   * and displays the seats within a row (e.g A1-A5, A8, A10, A11-A13)
   *
   * @return string
   */
  public function getSeatSummaryString()
  {
    return $this->seatSummaryString;
  }


  /**
   * The area that this seat is in (reserved seating only).
   *
   * @return string
   */
  public function getArea()
  {
    return $this->area;
  }


  /**
   * The block that this seat is in (reserved seating only).
   *
   * @return string
   */
  public function getBlock()
  {
    return $this->block;
  }


  /**
   * The row that this seat is in (reserved seating only).
   *
   * @return string
   */
  public function getRow()
  {
    return $this->row;
  }


  /**
   * The id of the priceband concession applied to this ticket if any.
   *
   * @return int
   */
  public function getPriceband_concessionid()
  {
    return $this->priceband_concessionid;
  }


  /**
   * The number of tickets in the group.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * The total value of this ticket or ticket group. This is simply quantity * final price.
   *
   * @return string
   */
  public function getTicketstotal()
  {
    return $this->ticketstotal;
  }


  /**
   * The price band name and concession title of this ticket/tickets.
   *
   * @return string
   */
  public function getTicketype()
  {
    return $this->ticketype;
  }


  /**
   * A pipe delimited String of the ids of tickets in this group.
   *
   * @return string
   */
  public function getTicketids()
  {
    return $this->ticketids;
  }


  /**
   * Whether this performance has reserved seating.
   *
   * @return bool
   */
  public function getReserved()
  {
    return $this->reserved;
  }


  /**
   * The list of ViaApiSeatDetails (seats) for this group of tickets.
   *
   * @return \Red61\Via\DataObject\ViaApiSeatDetails[]
   */
  public function getSeats()
  {
	return $this->seats ? : array();
  }


  /**
   * A user-friendly summary string for this group of tickets according to their reservation level.
   * Example for reservation level UNRESERVED/NONE: 10x Unreserved.
   * Example for reservation level AREA: 10x Area1.
   * Example for reservation level BLOCK: 10x Area1:Block1.
   * Example for reservation level ROW: 10x Area1:Block1:Row1
   * Example for reservation level SEAT: 10x Area1:Block1:A1-A5, A8, A10, A11-A13.
   *
   * @return string
   */
  public function getSummaryLabel()
  {
    return $this->summaryLabel;
  }


  /**
   * The reservation level for the price band these tickets belong to.
   *
   * @return string
   */
  public function getReservationLevel()
  {
    return $this->reservationLevel;
  }


  /**
   * The id of this concession.
   *
   * @return int
   */
  public function getConcessionid()
  {
    return $this->concessionid;
  }


  /**
   * The code of the concession applied to this group of tickets.
   *
   * @return string
   */
  public function getConcessionCode()
  {
    return $this->concessionCode;
  }


  /**
   * The price band title for this group of tickets.
   *
   * @return string
   */
  public function getPricebandTitle()
  {
    return $this->pricebandTitle;
  }


  /**
   * The title of the concession applied to this group of tickets.
   *
   * @return string
   */
  public function getConcessionTitle()
  {
    return $this->concessionTitle;
  }


  /**
   * The scope of this concession.
   * PB - Price Band	- A price band scoped concession.
   * PC - Peformance	- A performance scoped concession.
   * PBFP - Full Price - Full Price
   *
   * @return string
   */
  public function getScope()
  {
    return $this->scope;
  }


  /**
   * Whether or not this group of tickets is eligible for gift aid.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable portion of this concession.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The value of the tax on this group of tickets
   *
   * @return string
   */
  public function getTax()
  {
    return $this->tax;
  }


}
