<?php
/**
 * Defines the RawViaApiDonationFund data object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores the details of a donation.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiDonationFund.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiDonationFund.
 */
abstract class RawViaApiDonationFund {

  /**
   * The donation fund reference, i.e the {@code serverId}  and the {@code donationFundId}
   * in the format of {@code serverId:donationFundId}
   *
   * @var string
   */
  protected $donationFundRef;

  /**
   * The title for the donation fund the donation was given
   *
   * @var string
   */
  protected $title;

  /**
   * The value of the {@link ViaApiDonationFund#donationFundType} for this donation.
   *
   * @var double
   */
  protected $value;

  /**
   * The type of this donation fund, i.e (Fixed, Percentage, Round)
   *
   * @var string
   */
  protected $donationFundType;

  /**
   * The suggested amount for this donation. Used in {@link ViaApiService#apiGetBasketSuggestedDonations(int,
   * java.lang.String, java.lang.String) }
   *
   * @var double
   */
  protected $amount;

  /**
   * The list of event Ids linked to this donation fund
   *
   * @var int[]
   */
  protected $eventLinkedIds;

  /**
   * The description of the donation fund for which the donation was given.
   *
   * @var string
   */
  protected $description;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'donationFundRef':
        return $this->getDonationFundRef();
      case 'title':
        return $this->getTitle();
      case 'value':
        return $this->getValue();
      case 'donationFundType':
        return $this->getDonationFundType();
      case 'amount':
        return $this->getAmount();
      case 'eventLinkedIds':
        return $this->getEventLinkedIds();
      case 'description':
        return $this->getDescription();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The donation fund reference, i.e the {@code serverId}  and the {@code donationFundId}
   * in the format of {@code serverId:donationFundId}
   *
   * @return string
   */
  public function getDonationFundRef()
  {
    return $this->donationFundRef;
  }


  /**
   * The title for the donation fund the donation was given
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The value of the {@link ViaApiDonationFund#donationFundType} for this donation.
   *
   * @return double
   */
  public function getValue()
  {
    return $this->value;
  }


  /**
   * The type of this donation fund, i.e (Fixed, Percentage, Round)
   *
   * @return string
   */
  public function getDonationFundType()
  {
    return $this->donationFundType;
  }


  /**
   * The suggested amount for this donation. Used in {@link ViaApiService#apiGetBasketSuggestedDonations(int,
   * java.lang.String, java.lang.String) }
   *
   * @return double
   */
  public function getAmount()
  {
    return $this->amount;
  }


  /**
   * The list of event Ids linked to this donation fund
   *
   * @return int[]
   */
  public function getEventLinkedIds()
  {
	return $this->eventLinkedIds ? : array();
  }


  /**
   * The description of the donation fund for which the donation was given.
   *
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }


}
