<?php
/**
 * Defines the RawViaApiCustomerPerformanceInterest data object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores information on a performance that
 * the customer is interested in.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCustomerPerformanceInterest.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCustomerPerformanceInterest.
 */
abstract class RawViaApiCustomerPerformanceInterest {

  /**
   * The reference for the Performance in the form "serverId:performanceId".
   *
   * @var string
   */
  protected $id;

  /**
   * The title of the performance the customer is interested in.
   *
   * @var string
   */
  protected $title;

  /**
   * The reference for the Event in the form "serverId:eventId".
   *
   * @var string
   */
  protected $eventId;

  /**
   * The title of the event this performance belongs to.
   *
   * @var string
   */
  protected $eventTitle;

  /**
   * The date this performance takes place in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @var string
   */
  protected $dateTime;

  /**
   * The type of the customer's interest. e.g. "Favourites"
   *
   * @var string
   */
  protected $interestType;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'id':
        return $this->getId();
      case 'title':
        return $this->getTitle();
      case 'eventId':
        return $this->getEventId();
      case 'eventTitle':
        return $this->getEventTitle();
      case 'dateTime':
        return $this->getDateTime();
      case 'interestType':
        return $this->getInterestType();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference for the Performance in the form "serverId:performanceId".
   *
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }


  /**
   * The title of the performance the customer is interested in.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The reference for the Event in the form "serverId:eventId".
   *
   * @return string
   */
  public function getEventId()
  {
    return $this->eventId;
  }


  /**
   * The title of the event this performance belongs to.
   *
   * @return string
   */
  public function getEventTitle()
  {
    return $this->eventTitle;
  }


  /**
   * The date this performance takes place in the form "yyyy-MM-dd HH:mm:ss".
   * See the {@link java.text.SimpleDateFormat} documentation for information on this format.
   *
   * @return string
   */
  public function getDateTime()
  {
    return $this->dateTime;
  }


  /**
   * The type of the customer's interest. e.g. "Favourites"
   *
   * @return string
   */
  public function getInterestType()
  {
    return $this->interestType;
  }


}
