<?php
/**
 * Defines the RawViaApiBasket data object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Wrapper object that contains all the different item types which you may have in your basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiBasket.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiBasket.
 */
abstract class RawViaApiBasket {

  /**
   * An array of {@link ViaApiBasketEventItem} containing information on the tickets in this basket.
   *
   * @var \Red61\Via\DataObject\ViaApiBasketEventItem[]
   */
  protected $events;

  /**
   * An array of the merchandise in this basket, if any.
   *
   * @var \Red61\Via\DataObject\ViaApiMerchandiseBasketItem[]
   */
  protected $merchandise;

  /**
   * An array of vouchers for purchase in this basket, if any.
   *
   * @var \Red61\Via\DataObject\ViaApiVoucherTypeBasketItem[]
   */
  protected $vouchers;

  /**
   * An array of redeemed vouchers in this basket, if any.
   *
   * @var \Red61\Via\DataObject\ViaApiVoucherDetails[]
   */
  protected $voucherRedeams;

  /**
   * The donations in this basket, If any.
   *
   * @var \Red61\Via\DataObject\ViaApiDonationDetails[]
   */
  protected $donationDetails;

  /**
   * An array of scheme tiers in this basket, if any.
   *
   * @var \Red61\Via\DataObject\ViaApiSubscriptionBasketItem[]
   */
  protected $subscriptions;

  /**
   * Whether or not this basket has gift aidable items.
   *
   * @var bool
   */
  protected $hasGiftAidableItem;

  /**
   * Whether the customer has agreed to gift aid or not.
   *
   * @var bool
   */
  protected $createGiftAidDeclaration;

  /**
   * The basket summary
   *
   * @var \Red61\Via\DataObject\ViaApiBasketSummary
   */
  protected $summary;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'events':
        return $this->getEvents();
      case 'merchandise':
        return $this->getMerchandise();
      case 'vouchers':
        return $this->getVouchers();
      case 'voucherRedeams':
        return $this->getVoucherRedeams();
      case 'donationDetails':
        return $this->getDonationDetails();
      case 'subscriptions':
        return $this->getSubscriptions();
      case 'hasGiftAidableItem':
        return $this->getHasGiftAidableItem();
      case 'createGiftAidDeclaration':
        return $this->getCreateGiftAidDeclaration();
      case 'summary':
        return $this->getSummary();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * An array of {@link ViaApiBasketEventItem} containing information on the tickets in this basket.
   *
   * @return \Red61\Via\DataObject\ViaApiBasketEventItem[]
   */
  public function getEvents()
  {
	return $this->events ? : array();
  }


  /**
   * An array of the merchandise in this basket, if any.
   *
   * @return \Red61\Via\DataObject\ViaApiMerchandiseBasketItem[]
   */
  public function getMerchandise()
  {
	return $this->merchandise ? : array();
  }


  /**
   * An array of vouchers for purchase in this basket, if any.
   *
   * @return \Red61\Via\DataObject\ViaApiVoucherTypeBasketItem[]
   */
  public function getVouchers()
  {
	return $this->vouchers ? : array();
  }


  /**
   * An array of redeemed vouchers in this basket, if any.
   *
   * @return \Red61\Via\DataObject\ViaApiVoucherDetails[]
   */
  public function getVoucherRedeams()
  {
	return $this->voucherRedeams ? : array();
  }


  /**
   * The donations in this basket, If any.
   *
   * @return \Red61\Via\DataObject\ViaApiDonationDetails[]
   */
  public function getDonationDetails()
  {
	return $this->donationDetails ? : array();
  }


  /**
   * An array of scheme tiers in this basket, if any.
   *
   * @return \Red61\Via\DataObject\ViaApiSubscriptionBasketItem[]
   */
  public function getSubscriptions()
  {
	return $this->subscriptions ? : array();
  }


  /**
   * Whether or not this basket has gift aidable items.
   *
   * @return bool
   */
  public function getHasGiftAidableItem()
  {
    return $this->hasGiftAidableItem;
  }


  /**
   * Whether the customer has agreed to gift aid or not.
   *
   * @return bool
   */
  public function getCreateGiftAidDeclaration()
  {
    return $this->createGiftAidDeclaration;
  }


  /**
   * The basket summary
   *
   * @return \Red61\Via\DataObject\ViaApiBasketSummary
   */
  public function getSummary()
  {
    return $this->summary;
  }


}
