<?php
/**
 * Defines the RawapiGetPerformancesByDateRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Lists performances for the supplied event within the given date-time range.  Note: If the web user does not have
 * permission to list past performances then  the start date supplied should be greater than the current date and time
 * minus the allowance.   Otherwise the start date will be set to the current date and time minus the allowance.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetPerformancesByDateRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetPerformancesByDateRequest.
 */
abstract class RawapiGetPerformancesByDateRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetPerformancesByDate';

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @var string
   */
  protected $eventRef;

  /**
   * The minimum date and time at which a performance in the returned list can start. e.g. "2013-12-01 12:00"
   *
   * @var string
   */
  protected $startDateTime;

  /**
   * The maximum date and time at which a performance in the returned list can start. e.g. "2013-12-02 14:00"
   *
   * @var string
   */
  protected $endDateTime;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @return string
   */
  public function getEventRef()
  {
    return $this->eventRef;
  }


  /**
   * The serverId and eventId to list performances for in the form "serverId:eventId"
   *
   * @param string $eventRef
   *
   * @return $this
   */
  public function setEventRef($eventRef)
  {
    $this->eventRef = $eventRef;
    return $this;
  }

  /**
   * The minimum date and time at which a performance in the returned list can start. e.g. "2013-12-01 12:00"
   *
   * @return string
   */
  public function getStartDateTime()
  {
    return $this->startDateTime;
  }


  /**
   * The minimum date and time at which a performance in the returned list can start. e.g. "2013-12-01 12:00"
   *
   * @param string $startDateTime
   *
   * @return $this
   */
  public function setStartDateTime($startDateTime)
  {
    $this->startDateTime = $startDateTime;
    return $this;
  }

  /**
   * The maximum date and time at which a performance in the returned list can start. e.g. "2013-12-02 14:00"
   *
   * @return string
   */
  public function getEndDateTime()
  {
    return $this->endDateTime;
  }


  /**
   * The maximum date and time at which a performance in the returned list can start. e.g. "2013-12-02 14:00"
   *
   * @param string $endDateTime
   *
   * @return $this
   */
  public function setEndDateTime($endDateTime)
  {
    $this->endDateTime = $endDateTime;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
