<?php
/**
 * Defines the RawapiGetAddressRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Convert the address identifier from the apiSearchAddress() call into a fully populated AddressDetails object
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetAddressRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetAddressRequest.
 */
abstract class RawapiGetAddressRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetAddress';

  /**
   * Obtained from the reference field of a {@link ViaApiAddressResult} object which is itself obtained by calling
   * {@link #apiSearchAddress(com.red61.via.api.ViaApiAddressDetails, java.lang.String) }.
   *
   * @var string
   */
  protected $addressRef;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Obtained from the reference field of a {@link ViaApiAddressResult} object which is itself obtained by calling
   * {@link #apiSearchAddress(com.red61.via.api.ViaApiAddressDetails, java.lang.String) }.
   *
   * @return string
   */
  public function getAddressRef()
  {
    return $this->addressRef;
  }


  /**
   * Obtained from the reference field of a {@link ViaApiAddressResult} object which is itself obtained by calling
   * {@link #apiSearchAddress(com.red61.via.api.ViaApiAddressDetails, java.lang.String) }.
   *
   * @param string $addressRef
   *
   * @return $this
   */
  public function setAddressRef($addressRef)
  {
    $this->addressRef = $addressRef;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
