<?php
/**
 * Defines the RawapiCreateAccountRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates or updates a customer record. If <code>create</code> is  <code>true</code> and <code>customerId</code> is 0
 * then a new account  is created. Otherwise, if <code>create</code> is <code>false</code>  then the record identified
 * by <code>customerId</code> is updated.  If there is an existing customer record with the same email and password, the
 * existing record will be silently updated rather than creating a new customer, even though create == true
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateAccountRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateAccountRequest.
 */
abstract class RawapiCreateAccountRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCreateAccount';

  /**
   * <code>true</code> to create a new customer record, <code>false</code> to update an existing customer.
   *
   * @var bool
   */
  protected $create;

  /**
   * The title of the customer, Mr, Mrs etc..
   *
   * @var string
   */
  protected $title;

  /**
   * The forename of the customer.
   *
   * @var string
   */
  protected $forename;

  /**
   * The surname of the customer.
   *
   * @var string
   */
  protected $surname;

  /**
   * The address1 field of the customer's address.
   *
   * @var string
   */
  protected $address1;

  /**
   * The address2 field of the customer's address.
   *
   * @var string
   */
  protected $address2;

  /**
   * The address3 field of the customer's address.
   *
   * @var string
   */
  protected $address3;

  /**
   * The city of the customer's address.
   *
   * @var string
   */
  protected $city;

  /**
   * The county of the customer's address.
   *
   * @var string
   */
  protected $county;

  /**
   * The postcode of the customer's address.
   *
   * @var string
   */
  protected $postcode;

  /**
   * The country of the customer's address.
   *
   * @var string
   */
  protected $country;

  /**
   * The day phone number of the customer.
   *
   * @var string
   */
  protected $dayPhone;

  /**
   * The evening phone number of the customer.
   *
   * @var string
   */
  protected $eveningPhone;

  /**
   * The mobile phone number of the customer.
   *
   * @var string
   */
  protected $mobile;

  /**
   * The email of the customer.
   *
   * @var string
   */
  protected $email;

  /**
   * The preferred method of contact, [Any,Email,Phone]
   *
   * @var string
   */
  protected $preferredContactMethod;

  /**
   * The password of the customer.
   *
   * @var string
   */
  protected $password;

  /**
   * The password confirm field of the customer.
   *
   * @var string
   */
  protected $passwordConfirm;

  /**
   * Whether the customer allows organisation mailing.
   *
   * @var bool
   */
  protected $organisationMailingPermission;

  /**
   * Whether the customer allows third party mailing.
   *
   * @var bool
   */
  protected $thirdPartyMailingPermission;

  /**
   * Whether the customer allows additional mailing.
   *
   * @var bool
   */
  protected $additionalMailingPermission;

  /**
   * ID of the record to update, or <code>0</code> to create a new customer.
   *
   * @var int
   */
  protected $customerId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * <code>true</code> to create a new customer record, <code>false</code> to update an existing customer.
   *
   * @return bool
   */
  public function getCreate()
  {
    return $this->create;
  }


  /**
   * <code>true</code> to create a new customer record, <code>false</code> to update an existing customer.
   *
   * @param bool $create
   *
   * @return $this
   */
  public function setCreate($create)
  {
    $this->create = $create;
    return $this;
  }

  /**
   * The title of the customer, Mr, Mrs etc..
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The title of the customer, Mr, Mrs etc..
   *
   * @param string $title
   *
   * @return $this
   */
  public function setTitle($title)
  {
    $this->title = $title;
    return $this;
  }

  /**
   * The forename of the customer.
   *
   * @return string
   */
  public function getForename()
  {
    return $this->forename;
  }


  /**
   * The forename of the customer.
   *
   * @param string $forename
   *
   * @return $this
   */
  public function setForename($forename)
  {
    $this->forename = $forename;
    return $this;
  }

  /**
   * The surname of the customer.
   *
   * @return string
   */
  public function getSurname()
  {
    return $this->surname;
  }


  /**
   * The surname of the customer.
   *
   * @param string $surname
   *
   * @return $this
   */
  public function setSurname($surname)
  {
    $this->surname = $surname;
    return $this;
  }

  /**
   * The address1 field of the customer's address.
   *
   * @return string
   */
  public function getAddress1()
  {
    return $this->address1;
  }


  /**
   * The address1 field of the customer's address.
   *
   * @param string $address1
   *
   * @return $this
   */
  public function setAddress1($address1)
  {
    $this->address1 = $address1;
    return $this;
  }

  /**
   * The address2 field of the customer's address.
   *
   * @return string
   */
  public function getAddress2()
  {
    return $this->address2;
  }


  /**
   * The address2 field of the customer's address.
   *
   * @param string $address2
   *
   * @return $this
   */
  public function setAddress2($address2)
  {
    $this->address2 = $address2;
    return $this;
  }

  /**
   * The address3 field of the customer's address.
   *
   * @return string
   */
  public function getAddress3()
  {
    return $this->address3;
  }


  /**
   * The address3 field of the customer's address.
   *
   * @param string $address3
   *
   * @return $this
   */
  public function setAddress3($address3)
  {
    $this->address3 = $address3;
    return $this;
  }

  /**
   * The city of the customer's address.
   *
   * @return string
   */
  public function getCity()
  {
    return $this->city;
  }


  /**
   * The city of the customer's address.
   *
   * @param string $city
   *
   * @return $this
   */
  public function setCity($city)
  {
    $this->city = $city;
    return $this;
  }

  /**
   * The county of the customer's address.
   *
   * @return string
   */
  public function getCounty()
  {
    return $this->county;
  }


  /**
   * The county of the customer's address.
   *
   * @param string $county
   *
   * @return $this
   */
  public function setCounty($county)
  {
    $this->county = $county;
    return $this;
  }

  /**
   * The postcode of the customer's address.
   *
   * @return string
   */
  public function getPostcode()
  {
    return $this->postcode;
  }


  /**
   * The postcode of the customer's address.
   *
   * @param string $postcode
   *
   * @return $this
   */
  public function setPostcode($postcode)
  {
    $this->postcode = $postcode;
    return $this;
  }

  /**
   * The country of the customer's address.
   *
   * @return string
   */
  public function getCountry()
  {
    return $this->country;
  }


  /**
   * The country of the customer's address.
   *
   * @param string $country
   *
   * @return $this
   */
  public function setCountry($country)
  {
    $this->country = $country;
    return $this;
  }

  /**
   * The day phone number of the customer.
   *
   * @return string
   */
  public function getDayPhone()
  {
    return $this->dayPhone;
  }


  /**
   * The day phone number of the customer.
   *
   * @param string $dayPhone
   *
   * @return $this
   */
  public function setDayPhone($dayPhone)
  {
    $this->dayPhone = $dayPhone;
    return $this;
  }

  /**
   * The evening phone number of the customer.
   *
   * @return string
   */
  public function getEveningPhone()
  {
    return $this->eveningPhone;
  }


  /**
   * The evening phone number of the customer.
   *
   * @param string $eveningPhone
   *
   * @return $this
   */
  public function setEveningPhone($eveningPhone)
  {
    $this->eveningPhone = $eveningPhone;
    return $this;
  }

  /**
   * The mobile phone number of the customer.
   *
   * @return string
   */
  public function getMobile()
  {
    return $this->mobile;
  }


  /**
   * The mobile phone number of the customer.
   *
   * @param string $mobile
   *
   * @return $this
   */
  public function setMobile($mobile)
  {
    $this->mobile = $mobile;
    return $this;
  }

  /**
   * The email of the customer.
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * The email of the customer.
   *
   * @param string $email
   *
   * @return $this
   */
  public function setEmail($email)
  {
    $this->email = $email;
    return $this;
  }

  /**
   * The preferred method of contact, [Any,Email,Phone]
   *
   * @return string
   */
  public function getPreferredContactMethod()
  {
    return $this->preferredContactMethod;
  }


  /**
   * The preferred method of contact, [Any,Email,Phone]
   *
   * @param string $preferredContactMethod
   *
   * @return $this
   */
  public function setPreferredContactMethod($preferredContactMethod)
  {
    $this->preferredContactMethod = $preferredContactMethod;
    return $this;
  }

  /**
   * The password of the customer.
   *
   * @return string
   */
  public function getPassword()
  {
    return $this->password;
  }


  /**
   * The password of the customer.
   *
   * @param string $password
   *
   * @return $this
   */
  public function setPassword($password)
  {
    $this->password = $password;
    return $this;
  }

  /**
   * The password confirm field of the customer.
   *
   * @return string
   */
  public function getPasswordConfirm()
  {
    return $this->passwordConfirm;
  }


  /**
   * The password confirm field of the customer.
   *
   * @param string $passwordConfirm
   *
   * @return $this
   */
  public function setPasswordConfirm($passwordConfirm)
  {
    $this->passwordConfirm = $passwordConfirm;
    return $this;
  }

  /**
   * Whether the customer allows organisation mailing.
   *
   * @return bool
   */
  public function getOrganisationMailingPermission()
  {
    return $this->organisationMailingPermission;
  }


  /**
   * Whether the customer allows organisation mailing.
   *
   * @param bool $organisationMailingPermission
   *
   * @return $this
   */
  public function setOrganisationMailingPermission($organisationMailingPermission)
  {
    $this->organisationMailingPermission = $organisationMailingPermission;
    return $this;
  }

  /**
   * Whether the customer allows third party mailing.
   *
   * @return bool
   */
  public function getThirdPartyMailingPermission()
  {
    return $this->thirdPartyMailingPermission;
  }


  /**
   * Whether the customer allows third party mailing.
   *
   * @param bool $thirdPartyMailingPermission
   *
   * @return $this
   */
  public function setThirdPartyMailingPermission($thirdPartyMailingPermission)
  {
    $this->thirdPartyMailingPermission = $thirdPartyMailingPermission;
    return $this;
  }

  /**
   * Whether the customer allows additional mailing.
   *
   * @return bool
   */
  public function getAdditionalMailingPermission()
  {
    return $this->additionalMailingPermission;
  }


  /**
   * Whether the customer allows additional mailing.
   *
   * @param bool $additionalMailingPermission
   *
   * @return $this
   */
  public function setAdditionalMailingPermission($additionalMailingPermission)
  {
    $this->additionalMailingPermission = $additionalMailingPermission;
    return $this;
  }

  /**
   * ID of the record to update, or <code>0</code> to create a new customer.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID of the record to update, or <code>0</code> to create a new customer.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
