<?php
/**
 * Defines the RawapiCompleteOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method persists the payment information to the database, and completes the order depending  on whether the
 * payment was taken successfully or not. If payment was taken successfully all remote inventory servers in the order
 * are dispatched with payment and order information.  If no errors occur then the basket in removed.   If the payment
 * did not succeed then returning code will be a paymentError allowing another payment to be attempted by   by starting
 * the whole process again calling {@link #apiCreateInitialUnpaidOrder(String, String, String, String, String, String,
 * int, int, String, String)}  -> process payment independently -> {@link #apiCompleteOrder(int, boolean, String,
 * String, String, String, String, String, String, String, String)}
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCompleteOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCompleteOrderRequest.
 */
abstract class RawapiCompleteOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCompleteOrder';

  /**
   * the ID of the successfully created payment just processed, see {@link #apiCreateInitialUnpaidOrder(String, String,
   * String, String, String, String, int, int, String, String)}
   *
   * @var int
   */
  protected $paymentId;

  /**
   * <code>true</code> to indicate that the payment was taken successfully, <code>false</code> if the payment failed
   *
   * @var bool
   */
  protected $paymentSuccess;

  /**
   * unique identifier for a transaction communication if available
   *
   * @var string
   */
  protected $requestId;

  /**
   * terminal ID of the transaction if available
   *
   * @var string
   */
  protected $terminalId;

  /**
   * merchant ID supplied by the bank if available
   *
   * @var string
   */
  protected $merchantId;

  /**
   * sequence transaction number if available
   *
   * @var string
   */
  protected $stan;

  /**
   * authorisation code identifier for a transaction
   *
   * @var string
   */
  protected $authCode;

  /**
   * unique identifier for a transaction communication (see <code>requestId</code>) if available
   *
   * @var string
   */
  protected $receiptId;

  /**
   * the tracking reference used or returned from the independent payment processor
   *
   * @var string
   */
  protected $paymentProcessorTrackingValue;

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * the authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the ID of the successfully created payment just processed, see {@link #apiCreateInitialUnpaidOrder(String, String,
   * String, String, String, String, int, int, String, String)}
   *
   * @return int
   */
  public function getPaymentId()
  {
    return $this->paymentId;
  }


  /**
   * the ID of the successfully created payment just processed, see {@link #apiCreateInitialUnpaidOrder(String, String,
   * String, String, String, String, int, int, String, String)}
   *
   * @param int $paymentId
   *
   * @return $this
   */
  public function setPaymentId($paymentId)
  {
    $this->paymentId = $paymentId;
    return $this;
  }

  /**
   * <code>true</code> to indicate that the payment was taken successfully, <code>false</code> if the payment failed
   *
   * @return bool
   */
  public function getPaymentSuccess()
  {
    return $this->paymentSuccess;
  }


  /**
   * <code>true</code> to indicate that the payment was taken successfully, <code>false</code> if the payment failed
   *
   * @param bool $paymentSuccess
   *
   * @return $this
   */
  public function setPaymentSuccess($paymentSuccess)
  {
    $this->paymentSuccess = $paymentSuccess;
    return $this;
  }

  /**
   * unique identifier for a transaction communication if available
   *
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }


  /**
   * unique identifier for a transaction communication if available
   *
   * @param string $requestId
   *
   * @return $this
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
    return $this;
  }

  /**
   * terminal ID of the transaction if available
   *
   * @return string
   */
  public function getTerminalId()
  {
    return $this->terminalId;
  }


  /**
   * terminal ID of the transaction if available
   *
   * @param string $terminalId
   *
   * @return $this
   */
  public function setTerminalId($terminalId)
  {
    $this->terminalId = $terminalId;
    return $this;
  }

  /**
   * merchant ID supplied by the bank if available
   *
   * @return string
   */
  public function getMerchantId()
  {
    return $this->merchantId;
  }


  /**
   * merchant ID supplied by the bank if available
   *
   * @param string $merchantId
   *
   * @return $this
   */
  public function setMerchantId($merchantId)
  {
    $this->merchantId = $merchantId;
    return $this;
  }

  /**
   * sequence transaction number if available
   *
   * @return string
   */
  public function getStan()
  {
    return $this->stan;
  }


  /**
   * sequence transaction number if available
   *
   * @param string $stan
   *
   * @return $this
   */
  public function setStan($stan)
  {
    $this->stan = $stan;
    return $this;
  }

  /**
   * authorisation code identifier for a transaction
   *
   * @return string
   */
  public function getAuthCode()
  {
    return $this->authCode;
  }


  /**
   * authorisation code identifier for a transaction
   *
   * @param string $authCode
   *
   * @return $this
   */
  public function setAuthCode($authCode)
  {
    $this->authCode = $authCode;
    return $this;
  }

  /**
   * unique identifier for a transaction communication (see <code>requestId</code>) if available
   *
   * @return string
   */
  public function getReceiptId()
  {
    return $this->receiptId;
  }


  /**
   * unique identifier for a transaction communication (see <code>requestId</code>) if available
   *
   * @param string $receiptId
   *
   * @return $this
   */
  public function setReceiptId($receiptId)
  {
    $this->receiptId = $receiptId;
    return $this;
  }

  /**
   * the tracking reference used or returned from the independent payment processor
   *
   * @return string
   */
  public function getPaymentProcessorTrackingValue()
  {
    return $this->paymentProcessorTrackingValue;
  }


  /**
   * the tracking reference used or returned from the independent payment processor
   *
   * @param string $paymentProcessorTrackingValue
   *
   * @return $this
   */
  public function setPaymentProcessorTrackingValue($paymentProcessorTrackingValue)
  {
    $this->paymentProcessorTrackingValue = $paymentProcessorTrackingValue;
    return $this;
  }

  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see {@link #apiGetBasketSessionId(String)}.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * the authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
