<?php
/**
 * Defines the RawapiCleanUnpaidOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Clean up an unpaid api order.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCleanUnpaidOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCleanUnpaidOrderRequest.
 */
abstract class RawapiCleanUnpaidOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiCleanUnpaidOrder';

  /**
   * The order to clean.
   *
   * @var string
   */
  protected $orderRef;

  /**
   * Whether to email the customer
   *
   * @var bool
   */
  protected $emailCustomer;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The order to clean.
   *
   * @return string
   */
  public function getOrderRef()
  {
    return $this->orderRef;
  }


  /**
   * The order to clean.
   *
   * @param string $orderRef
   *
   * @return $this
   */
  public function setOrderRef($orderRef)
  {
    $this->orderRef = $orderRef;
    return $this;
  }

  /**
   * Whether to email the customer
   *
   * @return bool
   */
  public function getEmailCustomer()
  {
    return $this->emailCustomer;
  }


  /**
   * Whether to email the customer
   *
   * @param bool $emailCustomer
   *
   * @return $this
   */
  public function setEmailCustomer($emailCustomer)
  {
    $this->emailCustomer = $emailCustomer;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
