<?php
/**
 * Defines the RawapiAnswerQuestionnaireRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright 2015 Red61 Ltd
 * @licence   proprietary
 * @version   5.3.0-SNAPSHOT
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Stores the answers of a customer against the given questionnaire.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAnswerQuestionnaireRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAnswerQuestionnaireRequest.
 */
abstract class RawapiAnswerQuestionnaireRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiAnswerQuestionnaire';

  /**
   * The id of the customer answering the question.
   *
   * @var int
   */
  protected $customerId;

  /**
   * 
   *
   * @var string
   */
  protected $questionnaireRef;

  /**
   * An array of {@link ViaApiQuestionResponse} objects which store: questionRef - The reference to the question this
   * response is to in the form serverId:questionId text - The text of the customers answer to this question IF this
   * question is a freeform text question. answerRefs - An array of strings which contain the selected answers in the
   * form serverId:answerId if this question is not a freeform text question.
   *
   * @var \Red61\Via\DataObject\ViaApiQuestionResponse[]
   */
  protected $responses;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer answering the question.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer answering the question.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * 
   *
   * @return string
   */
  public function getQuestionnaireRef()
  {
    return $this->questionnaireRef;
  }


  /**
   * 
   *
   * @param string $questionnaireRef
   *
   * @return $this
   */
  public function setQuestionnaireRef($questionnaireRef)
  {
    $this->questionnaireRef = $questionnaireRef;
    return $this;
  }

  /**
   * An array of {@link ViaApiQuestionResponse} objects which store: questionRef - The reference to the question this
   * response is to in the form serverId:questionId text - The text of the customers answer to this question IF this
   * question is a freeform text question. answerRefs - An array of strings which contain the selected answers in the
   * form serverId:answerId if this question is not a freeform text question.
   *
   * @return \Red61\Via\DataObject\ViaApiQuestionResponse[]
   */
  public function getResponses()
  {
    return $this->responses;
  }


  /**
   * An array of {@link ViaApiQuestionResponse} objects which store: questionRef - The reference to the question this
   * response is to in the form serverId:questionId text - The text of the customers answer to this question IF this
   * question is a freeform text question. answerRefs - An array of strings which contain the selected answers in the
   * form serverId:answerId if this question is not a freeform text question.
   *
   * @param \Red61\Via\DataObject\ViaApiQuestionResponse[] $responses
   *
   * @return $this
   */
  public function setResponses($responses)
  {
    $this->responses = $responses;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
