<?php
/**
 * Defines the ViaApiOrderDetails VIA data object
 *
 * @author    Red61 Ltd
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 * @version   5.2.0
 */

namespace Red61\Via\DataObject;

/**
 * @package    Red61\Via\DataObject
 * {@inheritdoc}
 */
class ViaApiOrderDetails extends \Red61\Via\RawGenerated\DataObject\RawViaApiOrderDetails {

	/**
	 * @var int The error code, if any (extracted from the order reference)
	 */
	protected $errorCode;

	/**
	 * Checks if an order was successful. If not, you should check the error code and take appropriate action.
	 *
	 * @return bool
	 * @see \Red61\Via\ViaApiClient::createOrder
	 */
	public function wasSuccessful()
	{
		return ($this->getErrorCode() === NULL);
	}

	/**
	 * Convenience method to get the 3D secure URL if a 3DS redirect is required.
	 *
	 * @return string if a redirect is required, NULL otherwise
	 */
	public function get3DSecureUrl()
	{
		return $this->requires3DSecure() ? $this->getStatusmessage() : NULL;
	}

	/**
	 * Convenience method to check if the order status is that it requires a 3DSecure redirect
	 *
	 * @return bool
	 */
	public function requires3DSecure()
	{
		return ($this->getErrorCode() === -302);
	}

	/**
	 * Get the error code part of the response, if any.
	 *
	 * @return int or null if there was no error
	 */
	public function getErrorCode()
	{
		list($serverId, $orderId) = explode(':', $this->getCode());

		if ((int) $orderId > 0) {
			return NULL;
		} else {
			return (int) $orderId;
		}
	}
}
