<?php
/**
 * Defines ViaApiRequest
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * Base class for all API requests. The request objects extend as:
 *
 * ViaApiRequest
 *  - \Red61\Via\RawGenerated\ApiRequest\RawapiGetEventsRequest
 *  - \Red61\Via\ApiRequest\apiGetEventsRequest
 *
 * @package Red61\Via\ApiRequest
 */
abstract class ViaApiRequest {

	const SOAP_METHOD_NAME = NULL;

	/**
	 * Get the SOAP method name this class represents.
	 *
	 * @return string
	 * @throws \Exception if the method name is undefined
	 */
	public function getSoapMethodName()
	{
		if ( ! static::SOAP_METHOD_NAME) {
			throw new \Exception("The class ".get_class($this)." does not define a SOAP_METHOD_NAME constant");
		}
		return static::SOAP_METHOD_NAME;
	}

	/**
	 * Helper method to check over the listed fields and build an error array if any are empty
	 *
	 * @param array $fields
	 *
	 * @return array suitable for passing to a ClientInvalidRequestException
	 */
	protected function buildEmptyFieldErrorsFor($fields)
	{
		$errors = array();
		foreach ($fields as $field) {
			if ( ! $this->$field) {
				$errors[$field] = 'Must not be empty';
			}
		}

		return $errors;
	}

} 
