<?php
/**
 * Defines the RawViaApiTransactionPaymentDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * 
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTransactionPaymentDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTransactionPaymentDetails.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiTransactionPaymentDetails {

  /**
   * The reference of this payment in the form "serverId:paymentId"
   *
   * @var string
   */
  protected $paymentId;

  /**
   * The reference of the sale payment that this refund payment is refunding. In the form "serverId:paymentId". `null`
   * if `sale` is `true`
   *
   * @var string
   */
  protected $refundedPaymentId;

  /**
   * The reference of the exchanged order this payment is from. In the form "serverId:orderId". `null` if this payment
   * has been created in this transaction. This should only be set if the transaction this payment is from is an
   * exchange, see `ViaApiTransactionDetails#exchangedOrderId` or `ViaApiPurchaseSummary#exchangedOrderId` NOTE: not all
   * payments in an exchange are from a previous transaction.
   *
   * @var string
   */
  protected $sourceOrderId;

  /**
   * Payment type, either `Cash`, `Card`, `Cheque`, `Account` or `Complimentary`
   *
   * @var string
   */
  protected $type;

  /**
   * if `true` this is a sale payment, if `false` it's a refund payment.
   *
   * @var bool
   */
  protected $sale;

  /**
   * The value of this payment
   *
   * @var string
   */
  protected $amount;

  /**
   * The date of this payment in the form `yyyy-MM-dd HH:mm:ss`. See the `java.text.SimpleDateFormat` documentation for
   * information on this format.
   *
   * @var string
   */
  protected $date;

  /**
   * The status of the payment, either `Paid`, `Part Refunded` or `Refunded`. If `sale` is `false` then this can only
   * ever be `Paid`
   *
   * @var string
   */
  protected $status;

  /**
   * If type is `Account`, this is the title of the account
   *
   * @var string
   */
  protected $account;

  /**
   * The card type, eg VISA, Mastercard
   *
   * @var string
   */
  protected $cardType;

  /**
   * The card issuing bank if available
   *
   * @var string
   */
  protected $cardCompany;

  /**
   * The expiry date of the card in the form "mm:yy"
   *
   * @var string
   */
  protected $expiryDate;

  /**
   * The name on the card
   *
   * @var string
   */
  protected $cardHolderName;

  /**
   * The first six digits of the card, the BIN
   *
   * @var string
   */
  protected $cardBin;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'paymentId':
        return $this->getPaymentId();
      case 'refundedPaymentId':
        return $this->getRefundedPaymentId();
      case 'sourceOrderId':
        return $this->getSourceOrderId();
      case 'type':
        return $this->getType();
      case 'sale':
        return $this->getSale();
      case 'amount':
        return $this->getAmount();
      case 'date':
        return $this->getDate();
      case 'status':
        return $this->getStatus();
      case 'account':
        return $this->getAccount();
      case 'cardType':
        return $this->getCardType();
      case 'cardCompany':
        return $this->getCardCompany();
      case 'expiryDate':
        return $this->getExpiryDate();
      case 'cardHolderName':
        return $this->getCardHolderName();
      case 'cardBin':
        return $this->getCardBin();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this payment in the form "serverId:paymentId"
   *
   * @return string
   */
  public function getPaymentId()
  {
    return $this->paymentId;
  }


  /**
   * The reference of the sale payment that this refund payment is refunding. In the form "serverId:paymentId". `null`
   * if `sale` is `true`
   *
   * @return string
   */
  public function getRefundedPaymentId()
  {
    return $this->refundedPaymentId;
  }


  /**
   * The reference of the exchanged order this payment is from. In the form "serverId:orderId". `null` if this payment
   * has been created in this transaction. This should only be set if the transaction this payment is from is an
   * exchange, see `ViaApiTransactionDetails#exchangedOrderId` or `ViaApiPurchaseSummary#exchangedOrderId` NOTE: not all
   * payments in an exchange are from a previous transaction.
   *
   * @return string
   */
  public function getSourceOrderId()
  {
    return $this->sourceOrderId;
  }


  /**
   * Payment type, either `Cash`, `Card`, `Cheque`, `Account` or `Complimentary`
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * if `true` this is a sale payment, if `false` it's a refund payment.
   *
   * @return bool
   */
  public function getSale()
  {
    return $this->sale;
  }


  /**
   * The value of this payment
   *
   * @return string
   */
  public function getAmount()
  {
    return $this->amount;
  }


  /**
   * The date of this payment in the form `yyyy-MM-dd HH:mm:ss`. See the `java.text.SimpleDateFormat` documentation for
   * information on this format.
   *
   * @return string
   */
  public function getDate()
  {
    return $this->date;
  }


  /**
   * The status of the payment, either `Paid`, `Part Refunded` or `Refunded`. If `sale` is `false` then this can only
   * ever be `Paid`
   *
   * @return string
   */
  public function getStatus()
  {
    return $this->status;
  }


  /**
   * If type is `Account`, this is the title of the account
   *
   * @return string
   */
  public function getAccount()
  {
    return $this->account;
  }


  /**
   * The card type, eg VISA, Mastercard
   *
   * @return string
   */
  public function getCardType()
  {
    return $this->cardType;
  }


  /**
   * The card issuing bank if available
   *
   * @return string
   */
  public function getCardCompany()
  {
    return $this->cardCompany;
  }


  /**
   * The expiry date of the card in the form "mm:yy"
   *
   * @return string
   */
  public function getExpiryDate()
  {
    return $this->expiryDate;
  }


  /**
   * The name on the card
   *
   * @return string
   */
  public function getCardHolderName()
  {
    return $this->cardHolderName;
  }


  /**
   * The first six digits of the card, the BIN
   *
   * @return string
   */
  public function getCardBin()
  {
    return $this->cardBin;
  }


}
