<?php
/**
 * Defines the RawapiGetCustomerGiftAidDeclarationRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to retrieve all information on the gift aid declaration for the given customer and gift aid
 * declaration Id.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerGiftAidDeclarationRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerGiftAidDeclarationRequest.
 */
abstract class RawapiGetCustomerGiftAidDeclarationRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerGiftAidDeclaration';

  /**
   * The Id of the customer
   *
   * @var int
   */
  protected $customerId;

  /**
   * The Id of the gift aid declaration record
   *
   * @var int
   */
  protected $giftAidDeclarationId;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The Id of the customer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The Id of the customer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The Id of the gift aid declaration record
   *
   * @return int
   */
  public function getGiftAidDeclarationId()
  {
    return $this->giftAidDeclarationId;
  }


  /**
   * The Id of the gift aid declaration record
   *
   * @param int $giftAidDeclarationId
   *
   * @return $this
   */
  public function setGiftAidDeclarationId($giftAidDeclarationId)
  {
    $this->giftAidDeclarationId = $giftAidDeclarationId;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
