<?php
/**
 * Defines ViaApiCardPaymentRequestSpec - specifications for Red61\Via\DataObject\ViaApiCardPaymentRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\DataObject;

use spec\ObjectBehavior;
use spec\Support\SubjectProtectedPropertySetter;

/**
 *
 * @see Red61\Via\DataObject\ViaApiCardPaymentRequest
 */
class ViaApiCardPaymentRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     *
     * @var \Red61\Via\DataObject\ViaApiCardPaymentRequest
     */
    protected $subject;

    function it_is_initializable()
    {
        $this->subject->shouldHaveType('Red61\Via\DataObject\ViaApiCardPaymentRequest');
    }


    function it_was_successful_with_code_greater_than_zero()
    {
        SubjectProtectedPropertySetter::for_subject($this->subject)
            ->set_values(array(
            'code' => '5926:12323'
        ));
        $this->subject->wasSuccessful()->shouldBe(TRUE);
    }

    function it_was_not_successful_with_code_less_than_zero()
    {
        SubjectProtectedPropertySetter::for_subject($this->subject)
            ->set_values(array(
            'code' => '5926:-1',
        ));
        $this->subject->wasSuccessful()->shouldBe(FALSE);
    }

    function it_has_error_code_with_code_less_than_zero()
    {
        SubjectProtectedPropertySetter::for_subject($this->subject)
            ->set_values(array(
            'code' => '5926:-1',
        ));
        $this->subject->getErrorCode()->shouldBe(-1);
    }

    function it_has_no_error_code_with_order_reference()
    {
        SubjectProtectedPropertySetter::for_subject($this->subject)
            ->set_values(array(
            'code' => '5926:1234',
        ));
        $this->subject->getErrorCode()->shouldBe(NULL);
    }

}
