<?php
/**
 * Defines the RawViaApiBasketSummary data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains a summary of the items in the cart.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiBasketSummary.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiBasketSummary.
 */
abstract class RawViaApiBasketSummary {

  /**
   * The subtotal of the basket. This is the sum of items only.
   *
   * @var string
   */
  protected $subtotal;

  /**
   * The total of this basket. This includes all items, fees and discounts.
   *
   * @var string
   */
  protected $total;

  /**
   * The total gift aidable value of the basket. This is the value of any donations plus the gift aidable portion of any
   * tickets in the basket. API users who are not using gift aid can ignore this field.
   *
   * @var string
   */
  protected $donationTotal;

  /**
   * The fee total. This is order fee + postage fee.
   *
   * @var string
   */
  protected $feeTotal;

  /**
   * The order fee value
   *
   * @var string
   */
  protected $orderFee;

  /**
   * The ticket postage fee basket.
   *
   * @var string
   */
  protected $postageFee;

  /**
   * The merchandise fee amount applied to this basket.
   *
   * @var string
   */
  protected $merchandisePostageFee;

  /**
   * The total postage fee value.
   *
   * @var string
   */
  protected $postageFeeTotal;

  /**
   * The cobo fee amount applied to this basket.
   *
   * @var string
   */
  protected $coboFee;

  /**
   * The exchange fee amount applied to this basket.
   *
   * @var string
   */
  protected $exchangeFee;

  /**
   * The value of of any donations in the basket.
   *
   * @var string
   */
  protected $donationValue;

  /**
   * The discount applied to the basket from redeemed vouchers.
   *
   * @var string
   */
  protected $discountValue;

  /**
   * The discount applied to the basket from basket discounts.
   *
   * @var string
   */
  protected $basketDiscountValue;

  /**
   * The fee value applied to the basket from basket fees.
   *
   * @var string
   */
  protected $basketFee;

  /**
   * The id of the postage fee associated with this basket or 0 for none.
   *
   * @var int
   */
  protected $postageFeeId;

  /**
   * The number of tickets in the basket.
   *
   * @var int
   */
  protected $notickets;

  /**
   * The number of non tickets in the basket. I.e. vouchers, donations, merchandise and schemes,
   *
   * @var int
   */
  protected $nomisc;

  /**
   * The short form of the name of local tax, e.g VAT, GST
   *
   * @var string
   */
  protected $taxCode;

  /**
   * The total value of the tax applied to this basket
   *
   * @var string
   */
  protected $taxTotal;

  /**
   * The number of minutes until this basket expires.
   *
   * @var int
   */
  protected $timeToExpiry;

  /**
   * The current basket's delivery option
   *
   * @var string
   */
  protected $deliveryOption;

  /**
   * The title of the insurance product.
   *
   * @var string
   */
  protected $insuranceProduct;

  /**
   * The value of the applied insurance policy.
   *
   * @var string
   */
  protected $insuranceValue;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'subtotal':
        return $this->getSubtotal();
      case 'total':
        return $this->getTotal();
      case 'donationTotal':
        return $this->getDonationTotal();
      case 'feeTotal':
        return $this->getFeeTotal();
      case 'orderFee':
        return $this->getOrderFee();
      case 'postageFee':
        return $this->getPostageFee();
      case 'merchandisePostageFee':
        return $this->getMerchandisePostageFee();
      case 'postageFeeTotal':
        return $this->getPostageFeeTotal();
      case 'coboFee':
        return $this->getCoboFee();
      case 'exchangeFee':
        return $this->getExchangeFee();
      case 'donationValue':
        return $this->getDonationValue();
      case 'discountValue':
        return $this->getDiscountValue();
      case 'basketDiscountValue':
        return $this->getBasketDiscountValue();
      case 'basketFee':
        return $this->getBasketFee();
      case 'postageFeeId':
        return $this->getPostageFeeId();
      case 'notickets':
        return $this->getNotickets();
      case 'nomisc':
        return $this->getNomisc();
      case 'taxCode':
        return $this->getTaxCode();
      case 'taxTotal':
        return $this->getTaxTotal();
      case 'timeToExpiry':
        return $this->getTimeToExpiry();
      case 'deliveryOption':
        return $this->getDeliveryOption();
      case 'insuranceProduct':
        return $this->getInsuranceProduct();
      case 'insuranceValue':
        return $this->getInsuranceValue();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The subtotal of the basket. This is the sum of items only.
   *
   * @return string
   */
  public function getSubtotal()
  {
    return $this->subtotal;
  }


  /**
   * The total of this basket. This includes all items, fees and discounts.
   *
   * @return string
   */
  public function getTotal()
  {
    return $this->total;
  }


  /**
   * The total gift aidable value of the basket. This is the value of any donations plus the gift aidable portion of any
   * tickets in the basket. API users who are not using gift aid can ignore this field.
   *
   * @return string
   */
  public function getDonationTotal()
  {
    return $this->donationTotal;
  }


  /**
   * The fee total. This is order fee + postage fee.
   *
   * @return string
   */
  public function getFeeTotal()
  {
    return $this->feeTotal;
  }


  /**
   * The order fee value
   *
   * @return string
   */
  public function getOrderFee()
  {
    return $this->orderFee;
  }


  /**
   * The ticket postage fee basket.
   *
   * @return string
   */
  public function getPostageFee()
  {
    return $this->postageFee;
  }


  /**
   * The merchandise fee amount applied to this basket.
   *
   * @return string
   */
  public function getMerchandisePostageFee()
  {
    return $this->merchandisePostageFee;
  }


  /**
   * The total postage fee value.
   *
   * @return string
   */
  public function getPostageFeeTotal()
  {
    return $this->postageFeeTotal;
  }


  /**
   * The cobo fee amount applied to this basket.
   *
   * @return string
   */
  public function getCoboFee()
  {
    return $this->coboFee;
  }


  /**
   * The exchange fee amount applied to this basket.
   *
   * @return string
   */
  public function getExchangeFee()
  {
    return $this->exchangeFee;
  }


  /**
   * The value of of any donations in the basket.
   *
   * @return string
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The discount applied to the basket from redeemed vouchers.
   *
   * @return string
   */
  public function getDiscountValue()
  {
    return $this->discountValue;
  }


  /**
   * The discount applied to the basket from basket discounts.
   *
   * @return string
   */
  public function getBasketDiscountValue()
  {
    return $this->basketDiscountValue;
  }


  /**
   * The fee value applied to the basket from basket fees.
   *
   * @return string
   */
  public function getBasketFee()
  {
    return $this->basketFee;
  }


  /**
   * The id of the postage fee associated with this basket or 0 for none.
   *
   * @return int
   */
  public function getPostageFeeId()
  {
    return $this->postageFeeId;
  }


  /**
   * The number of tickets in the basket.
   *
   * @return int
   */
  public function getNotickets()
  {
    return $this->notickets;
  }


  /**
   * The number of non tickets in the basket. I.e. vouchers, donations, merchandise and schemes,
   *
   * @return int
   */
  public function getNomisc()
  {
    return $this->nomisc;
  }


  /**
   * The short form of the name of local tax, e.g VAT, GST
   *
   * @return string
   */
  public function getTaxCode()
  {
    return $this->taxCode;
  }


  /**
   * The total value of the tax applied to this basket
   *
   * @return string
   */
  public function getTaxTotal()
  {
    return $this->taxTotal;
  }


  /**
   * The number of minutes until this basket expires.
   *
   * @return int
   */
  public function getTimeToExpiry()
  {
    return $this->timeToExpiry;
  }


  /**
   * The current basket's delivery option
   *
   * @return string
   */
  public function getDeliveryOption()
  {
    return $this->deliveryOption;
  }


  /**
   * The title of the insurance product.
   *
   * @return string
   */
  public function getInsuranceProduct()
  {
    return $this->insuranceProduct;
  }


  /**
   * The value of the applied insurance policy.
   *
   * @return string
   */
  public function getInsuranceValue()
  {
    return $this->insuranceValue;
  }


}
