<?php
/**
 * Defines ViaApiOrderDetailsSpec - specifications for Red61\Via\DataObject\ViaApiOrderDetails
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\DataObject;

use spec\ObjectBehavior;
use Prophecy\Argument;
use spec\Support\SubjectProtectedPropertySetter;

/**
 *
 * @see Red61\Via\DataObject\ViaApiOrderDetails
 */
class ViaApiOrderDetailsSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\DataObject\ViaApiOrderDetails
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\DataObject\ViaApiOrderDetails');
	}

	function it_was_successful_with_code_greater_than_zero()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
			'code' => '5926:12323'
		));
		$this->subject->wasSuccessful()->shouldBe(TRUE);
	}

	function it_was_not_successful_with_code_less_than_zero()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
			'code' => '5926:-1'
		));
		$this->subject->wasSuccessful()->shouldBe(FALSE);
	}

	function it_has_error_code_with_code_less_than_zero()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
			'code' => '5926:-1'
		));
		$this->subject->getErrorCode()->shouldBe(-1);
	}

	function it_has_no_error_code_with_order_reference()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
			'code' => '5926:1234'
		));
		$this->subject->getErrorCode()->shouldBe(NULL);
	}

	function it_requires_3d_secure_confirmation_and_has_url_with_error_302()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
			'code'          => '5926:-302',
			'statusmessage' => 'https://3ds.somewhere?MD=foo'
		));

		$this->subject->requires3DSecure()->shouldBe(TRUE);
		$this->subject->get3DSecureUrl()->shouldBe('https://3ds.somewhere?MD=foo');
	}

	function it_does_not_require_3d_secure_confirmation_and_has_no_url_with_other_code()
	{
		SubjectProtectedPropertySetter::for_subject($this->subject)
			->set_values(array(
				'code'          => '5926:-5',
				'statusmessage' => 'Some problem'
			));
		$this->subject->requires3DSecure()->shouldBe(FALSE);
		$this->subject->get3DSecureUrl()->shouldBe(NULL);

	}

}
