<?php
/**
 * Defines ViaApiCustomerOtherDetailsSpec - specifications for Red61\Via\DataObject\ViaApiCustomerOtherDetails
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\DataObject;

use Red61\Via\ViaApiClient;
use spec\ObjectBehavior;
use Prophecy\Argument;
use spec\Support\SubjectMethodFinder;

/**
 *
 * @see Red61\Via\DataObject\ViaApiCustomerOtherDetails
 */
class ViaApiCustomerOtherDetailsSpec extends ObjectBehavior
{
	/**
	 * Use $this->subject to get proper type hinting for the subject class
	 * @var \Red61\Via\DataObject\ViaApiCustomerOtherDetails
	 */
	protected $subject;

	/**
	 * @var string
	 */
	protected $old_object_compatibility;

	function let()
	{
		$this->old_object_compatibility = ViaApiClient::$object_compatibility_mode;
	}

	function letgo()
	{
		ViaApiClient::$object_compatibility_mode = $this->old_object_compatibility;
	}

	function it_is_initializable()
	{
		$this->subject->shouldHaveType('Red61\Via\DataObject\ViaApiCustomerOtherDetails');
	}

	function it_can_be_created_with_customer_id_for_use_in_update_request()
	{
		$this->beConstructedWith('121923');
		$this->subject->getCustomerid()->shouldBe('121923');
	}

	/**
	 * Setters are not auto-generated but are required for use in update request. This spec ensures that all current and future
	 * properties have a setter unless they are blacklisted in this method.
	 */
	function it_has_setters_for_all_editable_properties_for_use_in_update_request()
	{
		$readonly_getters = array('getid', 'getcustomerid');
		foreach (SubjectMethodFinder::for_subject($this->subject)->find_matching('/^get/') as $getter_name) {
			if (in_array(strtolower($getter_name), $readonly_getters))
				continue;

			$setter = 'set'.substr($getter_name, 3);
			$value  = uniqid();
			$this->subject
					->$setter($value)
					->$getter_name()->shouldBe($value);
		}
	}

	/**
	 * Ensure that any manually created setters for properties removed or renamed in future are updated.
	 */
	function its_setters_refer_to_valid_properties()
	{
		ViaApiClient::$object_compatibility_mode = ViaApiClient::OBJECT_COMPATIBILITY_OFF;
		foreach (SubjectMethodFinder::for_subject($this->subject)->find_matching('/^set/') as $setter_name) {
			$this->subject->$setter_name(uniqid());
		}
	}

}
