<?php
/**
 * Defines the RawViaApiVoucherDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains the details of a customers voucher.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiVoucherDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiVoucherDetails.
 */
abstract class RawViaApiVoucherDetails {

  /**
   * The reference of this voucher of the form "serverId:voucherId"
   *
   * @var string
   */
  protected $voucherRef;

  /**
   * The title of this vouchers voucher type.
   *
   * @var string
   */
  protected $title;

  /**
   * The remaining credit on this voucher.
   *
   * @var double
   */
  protected $credit;

  /**
   * A string representation of the date this voucher will expire in the form "yyyy-MM-dd HH:mm:ss" See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $expiry;

  /**
   * The item id of this voucher in this transaction
   *
   * @var int
   */
  protected $itemId;

  /**
   * whether this voucher has been refunded
   *
   * @var bool
   */
  protected $refunded;

  /**
   * The forename of the customer that has claimed / been gifted this voucher using a token
   *
   * @var string
   */
  protected $customerForename;

  /**
   * The surname of the customer that has claimed / been gifted this voucher using a token
   *
   * @var string
   */
  protected $customerSurname;

  /**
   * The value of the tax on this voucher sale, 0.00 if refunded or not applicable
   *
   * @var double
   */
  protected $taxValue;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'voucherRef':
        return $this->getVoucherRef();
      case 'title':
        return $this->getTitle();
      case 'credit':
        return $this->getCredit();
      case 'expiry':
        return $this->getExpiry();
      case 'itemId':
        return $this->getItemId();
      case 'refunded':
        return $this->getRefunded();
      case 'customerForename':
        return $this->getCustomerForename();
      case 'customerSurname':
        return $this->getCustomerSurname();
      case 'taxValue':
        return $this->getTaxValue();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of this voucher of the form "serverId:voucherId"
   *
   * @return string
   */
  public function getVoucherRef()
  {
    return $this->voucherRef;
  }


  /**
   * The title of this vouchers voucher type.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The remaining credit on this voucher.
   *
   * @return double
   */
  public function getCredit()
  {
    return $this->credit;
  }


  /**
   * A string representation of the date this voucher will expire in the form "yyyy-MM-dd HH:mm:ss" See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getExpiry()
  {
    return $this->expiry;
  }


  /**
   * The item id of this voucher in this transaction
   *
   * @return int
   */
  public function getItemId()
  {
    return $this->itemId;
  }


  /**
   * whether this voucher has been refunded
   *
   * @return bool
   */
  public function getRefunded()
  {
    return $this->refunded;
  }


  /**
   * The forename of the customer that has claimed / been gifted this voucher using a token
   *
   * @return string
   */
  public function getCustomerForename()
  {
    return $this->customerForename;
  }


  /**
   * The surname of the customer that has claimed / been gifted this voucher using a token
   *
   * @return string
   */
  public function getCustomerSurname()
  {
    return $this->customerSurname;
  }


  /**
   * The value of the tax on this voucher sale, 0.00 if refunded or not applicable
   *
   * @return double
   */
  public function getTaxValue()
  {
    return $this->taxValue;
  }


}
