<?php
/**
 * Defines the RawapiGetQuestionnaireDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Returns the details of a given Questionnaire. If the customer ID parameter is supplied, all question definitions
 * should include that customer’s answers to any linked questionnaire type.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetQuestionnaireDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetQuestionnaireDetailsRequest.
 */
abstract class RawapiGetQuestionnaireDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetQuestionnaireDetails';

  /**
   * The id of the questionnaire to return details for
   *
   * @var int
   */
  protected $questionnaireId;

  /**
   * - the ID of the customer for whom you are retrieving the questionnaire. This should be used to pre-populate answers
   * in the response from any linked questionnaire that the customer has already submitted
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the questionnaire to return details for
   *
   * @return int
   */
  public function getQuestionnaireId()
  {
    return $this->questionnaireId;
  }


  /**
   * The id of the questionnaire to return details for
   *
   * @param int $questionnaireId
   *
   * @return $this
   */
  public function setQuestionnaireId($questionnaireId)
  {
    $this->questionnaireId = $questionnaireId;
    return $this;
  }

  /**
   * - the ID of the customer for whom you are retrieving the questionnaire. This should be used to pre-populate answers
   * in the response from any linked questionnaire that the customer has already submitted
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * - the ID of the customer for whom you are retrieving the questionnaire. This should be used to pre-populate answers
   * in the response from any linked questionnaire that the customer has already submitted
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
