<?php
/**
 * Defines ViaMemcachedDriverSpec - specifications for Red61\Via\Cache\ViaMemcachedDriver
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\Cache;

use Red61\Via\Cache\ViaCacheDriver;
use Red61\Via\Cache\ViaMemcachedDriver;
use spec\ObjectBehavior;


/**
 *
 * @see Red61\Via\Cache\ViaMemcachedDriver
 */
class ViaMemcachedDriverSpec extends ObjectBehavior
{

    /**
     * Use $this->subject to get proper type hinting for the subject class
     *
     * @var \Red61\Via\Cache\ViaMemcachedDriver
     */
    protected $subject;

    /**
     * @param \Red61\Via\Cache\NamespacedMemcachedAdaptor $mc_adaptor
     */
    function let($mc_adaptor)
    {
        $this->beConstructedWith($mc_adaptor, []);
    }

    function it_is_initializable()
    {
        $this->subject->shouldHaveType(ViaMemcachedDriver::class);
    }

    function it_is_a_via_cache_driver()
    {
        $this->subject->shouldHaveType(ViaCacheDriver::class);
    }

    /**
     * @param \Red61\Via\Cache\NamespacedMemcachedAdaptor $mc_adaptor
     */
    function it_looks_up_with_global_via_namespace($mc_adaptor)
    {
        // Ignore the call namespace and TTL they're not relevant for this driver
        $mc_adaptor->get(ViaMemcachedDriver::CACHE_NAMESPACE, 'apiStuff.ab23hasd')->willReturn('avalue');
        $this->subject->lookup('call-ns', 'apiStuff.ab23hasd', 1504)->shouldBe('avalue');
    }

    /**
     * @param \Red61\Via\Cache\NamespacedMemcachedAdaptor $mc_adaptor
     */
    function it_stores_with_global_via_namespace($mc_adaptor)
    {
        // Ignore the call namespace and TTL they're not relevant for this driver
        $this->subject->store('call-ns', 'apiStuff.ab23hasd', 'my value', 86400);
        $mc_adaptor->set(ViaMemcachedDriver::CACHE_NAMESPACE, 'apiStuff.ab23hasd', 'my value', 86400)
            ->shouldHaveBeenCalled();

    }

    /**
     * @param \Red61\Via\Cache\NamespacedMemcachedAdaptor $mc_adaptor
     */
    function it_flushes_just_the_via_namespace($mc_adaptor)
    {
        $this->subject->flush();
        $mc_adaptor->flushNamespace(ViaMemcachedDriver::CACHE_NAMESPACE)->shouldHaveBeenCalled();
    }
}
