<?php
/**
 * Defines the RawViaApiThreeDSecureV2BrowserInfo data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains the additional data required to perform 3DSv2 transactions e.g. :
 * 
 * acceptHeader : "text/html,application/xhtml+xml,application/xml;q=9,image/webp,img/apng,/;q=0.8" screenColorDepth :
 * "24" javaScriptEnabled : "1" ipAddress : "123.123.123.123" language : "en" screenHeight : "1080" screenWidth : "1920"
 * timeZone : "0" userAgent : "Mozilla/5.0 (Windows NT 6.1; Win64, x64) AppleWebKit/537.36 (KHTML, like Gecko)
 * Chrome/70.0.3538.110 Safari/537.36"
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiThreeDSecureV2BrowserInfo.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiThreeDSecureV2BrowserInfo.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiThreeDSecureV2BrowserInfo {

  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @var string
   */
  protected $acceptHeader;

  /**
   * This field contains a value representing the bit depth of the colour palette, in bits per pixel, for displaying
   * images. e.g. twenty four bit colour depth would be : "24"
   *
   * @var string
   */
  protected $screenColorDepth;

  /**
   * This field contains a value representing the ability of the cardholder's browser to execute JavaScript. Possible
   * values "0"=NotPresent, "1"=True, "2"=False
   *
   * @var string
   */
  protected $javaScriptEnabled;

  /**
   * This field contains the IP address of the cardholder's browser as returned by the HTTP headers.
   *
   * @var string
   */
  protected $ipAddress;

  /**
   * This field contains the cardholder's browser language as defined in IETF BCP 47.
   *
   * @var string
   */
  protected $language;

  /**
   * This field contains the total height of the cardholder's screen in pixels.
   *
   * @var string
   */
  protected $screenHeight;

  /**
   * This field contains the total width of the cardholder's screen in pixels.
   *
   * @var string
   */
  protected $screenWidth;

  /**
   * This field contains the difference between UTC time and the cardholder's browser local time in minutes.
   *
   * @var string
   */
  protected $timeZone;

  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @var string
   */
  protected $userAgent;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'acceptHeader':
        return $this->getAcceptHeader();
      case 'screenColorDepth':
        return $this->getScreenColorDepth();
      case 'javaScriptEnabled':
        return $this->getJavaScriptEnabled();
      case 'ipAddress':
        return $this->getIpAddress();
      case 'language':
        return $this->getLanguage();
      case 'screenHeight':
        return $this->getScreenHeight();
      case 'screenWidth':
        return $this->getScreenWidth();
      case 'timeZone':
        return $this->getTimeZone();
      case 'userAgent':
        return $this->getUserAgent();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @return string
   */
  public function getAcceptHeader()
  {
    return $this->acceptHeader;
  }


  /**
   * This field contains a value representing the bit depth of the colour palette, in bits per pixel, for displaying
   * images. e.g. twenty four bit colour depth would be : "24"
   *
   * @return string
   */
  public function getScreenColorDepth()
  {
    return $this->screenColorDepth;
  }


  /**
   * This field contains a value representing the ability of the cardholder's browser to execute JavaScript. Possible
   * values "0"=NotPresent, "1"=True, "2"=False
   *
   * @return string
   */
  public function getJavaScriptEnabled()
  {
    return $this->javaScriptEnabled;
  }


  /**
   * This field contains the IP address of the cardholder's browser as returned by the HTTP headers.
   *
   * @return string
   */
  public function getIpAddress()
  {
    return $this->ipAddress;
  }


  /**
   * This field contains the cardholder's browser language as defined in IETF BCP 47.
   *
   * @return string
   */
  public function getLanguage()
  {
    return $this->language;
  }


  /**
   * This field contains the total height of the cardholder's screen in pixels.
   *
   * @return string
   */
  public function getScreenHeight()
  {
    return $this->screenHeight;
  }


  /**
   * This field contains the total width of the cardholder's screen in pixels.
   *
   * @return string
   */
  public function getScreenWidth()
  {
    return $this->screenWidth;
  }


  /**
   * This field contains the difference between UTC time and the cardholder's browser local time in minutes.
   *
   * @return string
   */
  public function getTimeZone()
  {
    return $this->timeZone;
  }


  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @return string
   */
  public function getUserAgent()
  {
    return $this->userAgent;
  }


}
