<?php
/**
 * Defines the RawapiValidatePaymentPageHashRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is for validating that the hash provided to the pay page for a specific flow is correct based on the
 * session information. This method has a void return for a successful validation and will thrown an exception if it
 * fails to validate. See the exception message for an error message when validation fails.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiValidatePaymentPageHashRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiValidatePaymentPageHashRequest.
 */
abstract class RawapiValidatePaymentPageHashRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiValidatePaymentPageHash';

  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @var int
   */
  protected $flowIdentifier;

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The customer ID for the basket
   *
   * @var int
   */
  protected $customerId;

  /**
   * The hash needing validated. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @var string
   */
  protected $paymentPageHash;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @return int
   */
  public function getFlowIdentifier()
  {
    return $this->flowIdentifier;
  }


  /**
   * The ID of the specific flow through the pay page. The values supported are:
   * 
   * - The reservation payment link flow
   * - The pay by card / saved card flow
   * - The save card flow
   * - The cv2 capture flow
   *
   * @param int $flowIdentifier
   *
   * @return $this
   */
  public function setFlowIdentifier($flowIdentifier)
  {
    $this->flowIdentifier = $flowIdentifier;
    return $this;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The customer ID for the basket
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The customer ID for the basket
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The hash needing validated. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @return string
   */
  public function getPaymentPageHash()
  {
    return $this->paymentPageHash;
  }


  /**
   * The hash needing validated. To generate this hash see {@link apiGetPaymentPageHash
   *
   * @param string $paymentPageHash
   *
   * @return $this
   */
  public function setPaymentPageHash($paymentPageHash)
  {
    $this->paymentPageHash = $paymentPageHash;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
