<?php
/**
 * Defines the RawapiRemoveVoucherTypeFromBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Removes the given quantity of the given voucher types from the basket.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRemoveVoucherTypeFromBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRemoveVoucherTypeFromBasketRequest.
 */
abstract class RawapiRemoveVoucherTypeFromBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiRemoveVoucherTypeFromBasket';

  /**
   * The reference of the voucher type to remove in the form "serverId:voucherTypeId"
   *
   * @var string
   */
  protected $voucherTypeRef;

  /**
   * The quantity to remove from the basket.
   *
   * @var int
   */
  protected $quantity;

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The reference of the voucher type to remove in the form "serverId:voucherTypeId"
   *
   * @return string
   */
  public function getVoucherTypeRef()
  {
    return $this->voucherTypeRef;
  }


  /**
   * The reference of the voucher type to remove in the form "serverId:voucherTypeId"
   *
   * @param string $voucherTypeRef
   *
   * @return $this
   */
  public function setVoucherTypeRef($voucherTypeRef)
  {
    $this->voucherTypeRef = $voucherTypeRef;
    return $this;
  }

  /**
   * The quantity to remove from the basket.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * The quantity to remove from the basket.
   *
   * @param int $quantity
   *
   * @return $this
   */
  public function setQuantity($quantity)
  {
    $this->quantity = $quantity;
    return $this;
  }

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
