<?php
/**
 * Defines the RawapiGetCustomerDetailsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Gets all customer details for a supplied customer ID.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerDetailsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerDetailsRequest.
 */
abstract class RawapiGetCustomerDetailsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerDetails';

  /**
   * ID of the customer to lookup details for
   *
   * @var int
   */
  protected $customerId;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID of the customer to lookup details for
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID of the customer to lookup details for
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
