<?php
/**
 * Defines the RawapiAddSchemeToBasketRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Adds the specified scheme to the basket identified by `sessionId`.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiAddSchemeToBasketRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiAddSchemeToBasketRequest.
 */
abstract class RawapiAddSchemeToBasketRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiAddSchemeToBasket';

  /**
   * Reference of the scheme tier to add of the form serverId:schemeId:tierId
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The id of scheme tier concession
   *
   * @var int
   */
  protected $concessionId;

  /**
   * The ID of the customer subscribing to this scheme
   *
   * @var int
   */
  protected $customerId;

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * Reference of the scheme tier to add of the form serverId:schemeId:tierId
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * Reference of the scheme tier to add of the form serverId:schemeId:tierId
   *
   * @param string $schemeRef
   *
   * @return $this
   */
  public function setSchemeRef($schemeRef)
  {
    $this->schemeRef = $schemeRef;
    return $this;
  }

  /**
   * The id of scheme tier concession
   *
   * @return int
   */
  public function getConcessionId()
  {
    return $this->concessionId;
  }


  /**
   * The id of scheme tier concession
   *
   * @param int $concessionId
   *
   * @return $this
   */
  public function setConcessionId($concessionId)
  {
    $this->concessionId = $concessionId;
    return $this;
  }

  /**
   * The ID of the customer subscribing to this scheme
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The ID of the customer subscribing to this scheme
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
