<?php
/**
 * Defines the RawViaApiCustomerOtherDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores extra details of a customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiCustomerOtherDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiCustomerOtherDetails.
 */
abstract class RawViaApiCustomerOtherDetails {

  /**
   * The id of this record.
   *
   * @var int
   */
  protected $id;

  /**
   * The id of the customer these details are for.
   *
   * @var int
   */
  protected $customerid;

  /**
   * The daytime phone number of the customer.
   *
   * @var string
   */
  protected $dayphone;

  /**
   * The evening phone number of the customer.
   *
   * @var string
   */
  protected $evephone;

  /**
   * The fax number of the customer.
   *
   * @var string
   */
  protected $fax;

  /**
   * The mobile phone number of the customer.
   *
   * @var string
   */
  protected $mobile;

  /**
   * The email of the customer.
   *
   * @var string
   */
  protected $email;

  /**
   * The preferred contact method of the customer. One of "Any", "Email" or "Post". May also be empty if no data is
   * stored.
   *
   * @var string
   */
  protected $prefcontact;

  /**
   * The first line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet1;

  /**
   * The second line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet2;

  /**
   * The third line of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstreet3;

  /**
   * The city of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcity;

  /**
   * The county of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcounty;

  /**
   * The country of the alternative address if one exists.
   *
   * @var string
   */
  protected $altcountry;

  /**
   * The po box of the alternative address if one exists.
   *
   * @var string
   */
  protected $altpobox;

  /**
   * The state of the alternative address if one exists.
   *
   * @var string
   */
  protected $altstate;

  /**
   * The post code of the alternative address if one exists.
   *
   * @var string
   */
  protected $altpostcode;

  /**
   * The customer's gender in the format "M" (for Male), "F" (for Female), "N" (for Non-binary)
   *
   * @var string
   */
  protected $gender;

  /**
   * The customer's date of birth e.g. "1990-12-01"
   *
   * @var string
   */
  protected $dateOfBirth;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'id':
        return $this->getId();
      case 'customerid':
        return $this->getCustomerid();
      case 'dayphone':
        return $this->getDayphone();
      case 'evephone':
        return $this->getEvephone();
      case 'fax':
        return $this->getFax();
      case 'mobile':
        return $this->getMobile();
      case 'email':
        return $this->getEmail();
      case 'prefcontact':
        return $this->getPrefcontact();
      case 'altstreet1':
        return $this->getAltstreet1();
      case 'altstreet2':
        return $this->getAltstreet2();
      case 'altstreet3':
        return $this->getAltstreet3();
      case 'altcity':
        return $this->getAltcity();
      case 'altcounty':
        return $this->getAltcounty();
      case 'altcountry':
        return $this->getAltcountry();
      case 'altpobox':
        return $this->getAltpobox();
      case 'altstate':
        return $this->getAltstate();
      case 'altpostcode':
        return $this->getAltpostcode();
      case 'gender':
        return $this->getGender();
      case 'dateOfBirth':
        return $this->getDateOfBirth();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The id of this record.
   *
   * @return int
   */
  public function getId()
  {
    return $this->id;
  }


  /**
   * The id of the customer these details are for.
   *
   * @return int
   */
  public function getCustomerid()
  {
    return $this->customerid;
  }


  /**
   * The daytime phone number of the customer.
   *
   * @return string
   */
  public function getDayphone()
  {
    return $this->dayphone;
  }


  /**
   * The evening phone number of the customer.
   *
   * @return string
   */
  public function getEvephone()
  {
    return $this->evephone;
  }


  /**
   * The fax number of the customer.
   *
   * @return string
   */
  public function getFax()
  {
    return $this->fax;
  }


  /**
   * The mobile phone number of the customer.
   *
   * @return string
   */
  public function getMobile()
  {
    return $this->mobile;
  }


  /**
   * The email of the customer.
   *
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }


  /**
   * The preferred contact method of the customer. One of "Any", "Email" or "Post". May also be empty if no data is
   * stored.
   *
   * @return string
   */
  public function getPrefcontact()
  {
    return $this->prefcontact;
  }


  /**
   * The first line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet1()
  {
    return $this->altstreet1;
  }


  /**
   * The second line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet2()
  {
    return $this->altstreet2;
  }


  /**
   * The third line of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstreet3()
  {
    return $this->altstreet3;
  }


  /**
   * The city of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcity()
  {
    return $this->altcity;
  }


  /**
   * The county of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcounty()
  {
    return $this->altcounty;
  }


  /**
   * The country of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltcountry()
  {
    return $this->altcountry;
  }


  /**
   * The po box of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltpobox()
  {
    return $this->altpobox;
  }


  /**
   * The state of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltstate()
  {
    return $this->altstate;
  }


  /**
   * The post code of the alternative address if one exists.
   *
   * @return string
   */
  public function getAltpostcode()
  {
    return $this->altpostcode;
  }


  /**
   * The customer's gender in the format "M" (for Male), "F" (for Female), "N" (for Non-binary)
   *
   * @return string
   */
  public function getGender()
  {
    return $this->gender;
  }


  /**
   * The customer's date of birth e.g. "1990-12-01"
   *
   * @return string
   */
  public function getDateOfBirth()
  {
    return $this->dateOfBirth;
  }


}
