<?php
/**
 * Defines the RawapiConvertReservationRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Converts tickets within a reservation. If the `itemIds` List is empty or `null` the system will convert all remaining
 * active tickets within the reservation. An active ticket is one that has not been released or already converted.
 * Converting a reservation will take the specified tickets and add them to the basket defined by `sessionId`.
 * Converting **IS POSSIBLE** if this basket already has items in it. The `convertingBehaviour` controls how the system
 * handles the ticket offers present against the tickets being converted. This has 3 values:
 * 
 * - **disregard** : all tickets will be added at full price
 * - **available** : all tickets will be added with best ticket offers currently available
 * - **forced** : all tickets will be added with the ticket offer reserved at the time of the reservation, if still
 * possible. If not it will fail
 * 
 * Different `convertingBehaviour` values will impose different restrictions on the converting process, with `forced`
 * being the most restrictive.
 * 
 * **WARNING:** The active basket will have its customer set to the customer of the reservation.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiConvertReservationRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiConvertReservationRequest.
 */
abstract class RawapiConvertReservationRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiConvertReservation';

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @var string
   */
  protected $orderId;

  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be converted. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be converted.
   *
   * @var int[]
   */
  protected $itemIds;

  /**
   * either "**disregard**" or "**available**" or "**forced**". See above for details.
   *
   * @var string
   */
  protected $convertingBehaviour;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @return string
   */
  public function getOrderId()
  {
    return $this->orderId;
  }


  /**
   * The order ID of the reservation in the form 'serverId:orderId'. See `ViaApiPurchaseSummary#orderid`
   * `ViaApiTransactionDetails#orderid`
   *
   * @param string $orderId
   *
   * @return $this
   */
  public function setOrderId($orderId)
  {
    $this->orderId = $orderId;
    return $this;
  }

  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be converted. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be converted.
   *
   * @return int[]
   */
  public function getItemIds()
  {
    return $this->itemIds;
  }


  /**
   * A list of the item Ids, `ViaApiTicketItemDetails#itemId`s or `ViaApiTicketItemDetailsWithStatus#itemId`s, of the
   * active tickets within this reservation to be converted. If the field `ViaApiTicketItemDetails#reservationStatus` or
   * `ViaApiTicketItemDetailsWithStatus#reservationStatus` is **`Pending`** then the ticket is active at the time of
   * loading. See `ViaApiPurchaseSummary#products` or `ViaApiTransactionDetails#products` for grouped tickets within the
   * reservation, then `ViaApiTicketDetails#ticketItems` or `ViaApiTicketDetailsWithStatus#ticketItems` for individual
   * tickets. If `null` or empty all remaining active tickets within this reservation will be converted.
   *
   * @param int[] $itemIds
   *
   * @return $this
   */
  public function setItemIds($itemIds)
  {
    $this->itemIds = $itemIds;
    return $this;
  }

  /**
   * either "**disregard**" or "**available**" or "**forced**". See above for details.
   *
   * @return string
   */
  public function getConvertingBehaviour()
  {
    return $this->convertingBehaviour;
  }


  /**
   * either "**disregard**" or "**available**" or "**forced**". See above for details.
   *
   * @param string $convertingBehaviour
   *
   * @return $this
   */
  public function setConvertingBehaviour($convertingBehaviour)
  {
    $this->convertingBehaviour = $convertingBehaviour;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
