<?php
/**
 * Defines the ViaPluginInterface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\Plugin;

/**
 * Implement this interface and register with the ViaPluginManager to receive events during
 * execution of VIA API calls.
 *
 * @package Red61\Via\Plugin
 */
interface ViaPluginInterface {

	/**
	 * Receives and handles a ViaPluginNotification. The types of notifications received are
	 * controlled by the arguments you pass when registering your plugin with the ViaPluginManager.
	 *
	 * @param ViaPluginNotification $notification
	 *
	 * @return void
	 */
	public function onViaPluginNotification(ViaPluginNotification $notification);
} 
