<?php
/**
 * Defines the OrderCompletingRequest instance
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;


/**
 * This interface identifies API requests that complete an order and should therefore clear the basket ID
 * on successful execution.
 *
 * @package Red61\Via\ApiRequest
 */
interface AuthenticatedRequest {

	/**
	 * authentication code
	 *
	 * @return string
	 */
	public function getWebKey();

	/**
	 * authentication code
	 *
	 * @param string $webKey
	 *
	 * @return $this
	 */
	public function setWebKey($webKey);

} 
