<?php
/**
 * Defines the RawViaApiFeeItemDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Stores basic information on a particular fee and fee band.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiFeeItemDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiFeeItemDetails.
 */
abstract class RawViaApiFeeItemDetails {

  /**
   * The reference for this fee of the form "serverId:feeId".
   *
   * @var string
   */
  protected $feeId;

  /**
   * The reference for this fee band of the form "serverId:feeBandId". This will not be set for event/shared event fees.
   *
   * @var string
   */
  protected $feeBandId;

  /**
   * The title of this fee.
   *
   * @var string
   */
  protected $title;

  /**
   * The title of this fee band. This will not be set for event/shared event fees.
   *
   * @var string
   */
  protected $bandTitle;

  /**
   * A flag indicating if this fee is shared across multiple events.
   *
   * @var bool
   */
  protected $shared;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'feeId':
        return $this->getFeeId();
      case 'feeBandId':
        return $this->getFeeBandId();
      case 'title':
        return $this->getTitle();
      case 'bandTitle':
        return $this->getBandTitle();
      case 'shared':
        return $this->getShared();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference for this fee of the form "serverId:feeId".
   *
   * @return string
   */
  public function getFeeId()
  {
    return $this->feeId;
  }


  /**
   * The reference for this fee band of the form "serverId:feeBandId". This will not be set for event/shared event fees.
   *
   * @return string
   */
  public function getFeeBandId()
  {
    return $this->feeBandId;
  }


  /**
   * The title of this fee.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The title of this fee band. This will not be set for event/shared event fees.
   *
   * @return string
   */
  public function getBandTitle()
  {
    return $this->bandTitle;
  }


  /**
   * A flag indicating if this fee is shared across multiple events.
   *
   * @return bool
   */
  public function getShared()
  {
    return $this->shared;
  }


}
