<?php
/**
 * Defines the BasketIdRequiredRequest interface
 *
 * @author    Andrew Coulton <andrew@ingenerator.com>
 * @copyright 2014 Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;


/**
 * This interface identifies requests that can take an optional sessionId property if a VIA basket has
 * been initialised but that don't require it.
 *
 * @package Red61\Via\ApiRequest
 */
interface BasketIdOptionalRequest {

	/**
	 * The ID for the basket being used
	 *
	 * @return string
	 * @see \Red61\Via\ViaApiClient::getBasketId
	 */
	public function getSessionId();


	/**
	 * The ID for the basket being used
	 *
	 * @param string $sessionId
	 *
	 * @return $this
	 * @see \Red61\Via\ViaApiClient::getBasketId
	 */
	public function setSessionId($sessionId);

}
