<?php
/**
 * Defines the RawapiSendPasswordResetEmailRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Generates a password reset token and sends a customer password reset email to the supplied email address
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSendPasswordResetEmailRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSendPasswordResetEmailRequest.
 */
abstract class RawapiSendPasswordResetEmailRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiSendPasswordResetEmail';

  /**
   * The customers email
   *
   * @var string
   */
  protected $customerEmail;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The customers email
   *
   * @return string
   */
  public function getCustomerEmail()
  {
    return $this->customerEmail;
  }


  /**
   * The customers email
   *
   * @param string $customerEmail
   *
   * @return $this
   */
  public function setCustomerEmail($customerEmail)
  {
    $this->customerEmail = $customerEmail;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
