<?php
/**
 * Defines the RawapiEventDetailedSearchRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Searches for events based on the supplied parameters. `typeid` and `subtypeid` must be used in conjunction with other
 * parameters (otherwise no results are returned). This method will attempt translation of it's returned objects, where
 * available.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiEventDetailedSearchRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiEventDetailedSearchRequest.
 */
abstract class RawapiEventDetailedSearchRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiEventDetailedSearch';

  /**
   * The event name.
   *
   * @var string
   */
  protected $event;

  /**
   * The venue name.
   *
   * @var string
   */
  protected $venue;

  /**
   * The subvenue name.
   *
   * @var string
   */
  protected $subvenue;

  /**
   * The artist name.
   *
   * @var string
   */
  protected $company;

  /**
   * The promoter name.
   *
   * @var string
   */
  protected $promoter;

  /**
   * The start of an events performances.
   *
   * @var string
   */
  protected $startDate;

  /**
   * The enddate of an events performances (not inclusive).
   *
   * @var string
   */
  protected $endingDate;

  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @var int
   */
  protected $typeId;

  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @var int
   */
  protected $subTypeId;

  /**
   * 
   *
   * @var string[]
   */
  protected $ageSuitabilityCodes;

  /**
   * 
   *
   * @var bool
   */
  protected $quickSearch;

  /**
   * The season code.
   *
   * @var string
   */
  protected $seasonCode;

  /**
   * the authentication code to use
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The event name.
   *
   * @return string
   */
  public function getEvent()
  {
    return $this->event;
  }


  /**
   * The event name.
   *
   * @param string $event
   *
   * @return $this
   */
  public function setEvent($event)
  {
    $this->event = $event;
    return $this;
  }

  /**
   * The venue name.
   *
   * @return string
   */
  public function getVenue()
  {
    return $this->venue;
  }


  /**
   * The venue name.
   *
   * @param string $venue
   *
   * @return $this
   */
  public function setVenue($venue)
  {
    $this->venue = $venue;
    return $this;
  }

  /**
   * The subvenue name.
   *
   * @return string
   */
  public function getSubvenue()
  {
    return $this->subvenue;
  }


  /**
   * The subvenue name.
   *
   * @param string $subvenue
   *
   * @return $this
   */
  public function setSubvenue($subvenue)
  {
    $this->subvenue = $subvenue;
    return $this;
  }

  /**
   * The artist name.
   *
   * @return string
   */
  public function getCompany()
  {
    return $this->company;
  }


  /**
   * The artist name.
   *
   * @param string $company
   *
   * @return $this
   */
  public function setCompany($company)
  {
    $this->company = $company;
    return $this;
  }

  /**
   * The promoter name.
   *
   * @return string
   */
  public function getPromoter()
  {
    return $this->promoter;
  }


  /**
   * The promoter name.
   *
   * @param string $promoter
   *
   * @return $this
   */
  public function setPromoter($promoter)
  {
    $this->promoter = $promoter;
    return $this;
  }

  /**
   * The start of an events performances.
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * The start of an events performances.
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * The enddate of an events performances (not inclusive).
   *
   * @return string
   */
  public function getEndingDate()
  {
    return $this->endingDate;
  }


  /**
   * The enddate of an events performances (not inclusive).
   *
   * @param string $endingDate
   *
   * @return $this
   */
  public function setEndingDate($endingDate)
  {
    $this->endingDate = $endingDate;
    return $this;
  }

  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @return int
   */
  public function getTypeId()
  {
    return $this->typeId;
  }


  /**
   * The type ID. Must be used in conjunction with another parameter.
   *
   * @param int $typeId
   *
   * @return $this
   */
  public function setTypeId($typeId)
  {
    $this->typeId = $typeId;
    return $this;
  }

  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @return int
   */
  public function getSubTypeId()
  {
    return $this->subTypeId;
  }


  /**
   * The sub-type ID. Must be used in conjunction with another parameter.
   *
   * @param int $subTypeId
   *
   * @return $this
   */
  public function setSubTypeId($subTypeId)
  {
    $this->subTypeId = $subTypeId;
    return $this;
  }

  /**
   * 
   *
   * @return string[]
   */
  public function getAgeSuitabilityCodes()
  {
    return $this->ageSuitabilityCodes;
  }


  /**
   * 
   *
   * @param string[] $ageSuitabilityCodes
   *
   * @return $this
   */
  public function setAgeSuitabilityCodes($ageSuitabilityCodes)
  {
    $this->ageSuitabilityCodes = $ageSuitabilityCodes;
    return $this;
  }

  /**
   * 
   *
   * @return bool
   */
  public function getQuickSearch()
  {
    return $this->quickSearch;
  }


  /**
   * 
   *
   * @param bool $quickSearch
   *
   * @return $this
   */
  public function setQuickSearch($quickSearch)
  {
    $this->quickSearch = $quickSearch;
    return $this;
  }

  /**
   * The season code.
   *
   * @return string
   */
  public function getSeasonCode()
  {
    return $this->seasonCode;
  }


  /**
   * The season code.
   *
   * @param string $seasonCode
   *
   * @return $this
   */
  public function setSeasonCode($seasonCode)
  {
    $this->seasonCode = $seasonCode;
    return $this;
  }

  /**
   * the authentication code to use
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * the authentication code to use
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
