<?php


namespace Red61\Via\Cache;


use Red61\Via\Exception\CacheNotAvailableException;

class MemcachedOperationFailedException extends CacheNotAvailableException
{

    /**
     * Create and format a message using the memcached result and the current server list for debugging
     *
     * @param int    $result_code
     * @param string $result_message
     * @param array  $server_list
     */
    public function __construct($result_code, $result_message, array $server_list)
    {
        if (empty($server_list)) {
            $servers = 'No server configured';
        } else {
            $servers = 'Servers: '.implode(
                    ', ',
                    array_map(
                        function ($srv) { return $srv['host'].':'.$srv['port']; },
                        $server_list
                    )
                );
        }

        parent::__construct(
            sprintf('Memcache failed: %s:%s (%s)', $result_code, $result_message, $servers)
        );
    }

}