<?php
/**
 * Defines the RawViaApiTicketDetailsWithStatus data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Contains the details of a ticket or tickets in an order. For reserved performances quantity will always be one.
 * Otherwise similar tickets are grouped. Similar to `ViaApiTicketDetails` with one difference, the `ticketItems` field
 * is a List of `ViaApiTicketItemDetailsWithStatus`
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTicketDetailsWithStatus.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiTicketDetailsWithStatus {

  /**
   * The venue title of the venue these tickets are for.
   *
   * @var string
   */
  protected $venue;

  /**
   * The venue reference of the venue these tickets are for in the form "serverId:venueId".
   *
   * @var string
   */
  protected $venueId;

  /**
   * The subvenue title of the subvenue these tickets are for.
   *
   * @var string
   */
  protected $subvenue;

  /**
   * The subvenue reference of the subvenue these tickets are for in the form "serverId:subvenueId".
   *
   * @var string
   */
  protected $subvenueId;

  /**
   * The event title of the event these tickets are for.
   *
   * @var string
   */
  protected $event;

  /**
   * The event reference of the event these tickets are for in the form "serverId:eventId".
   *
   * @var string
   */
  protected $eventId;

  /**
   * The performance title of the performance these tickets are for.
   *
   * @var string
   */
  protected $performance;

  /**
   * The performance reference of the performance these tickets are for in the form "serverId:performanceId".
   *
   * @var string
   */
  protected $performanceId;

  /**
   * The date of the performance these tickets are for in the form "yyyy-MM-dd HH:mm:ss". Note, can be NULL for Digital
   * on demand performances See the `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $date;

  /**
   * The quantity of tickets.
   *
   * @var int
   */
  protected $quantity;

  /**
   * The title of the price band these tickets are for.
   *
   * @var string
   */
  protected $priceband;

  /**
   * The title of any performance concession applied to these tickets.
   *
   * @var string
   */
  protected $performanceconcession;

  /**
   * The title of any price band concession applied to these tickets.
   *
   * @var string
   */
  protected $pricebandconcession;

  /**
   * The code of any performance concession applied to these tickets.
   *
   * @var string
   */
  protected $performanceconcessioncode;

  /**
   * The code of any price band concession applied to these tickets.
   *
   * @var string
   */
  protected $pricebandconcessioncode;

  /**
   * The area these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @var string
   */
  protected $area;

  /**
   * The block these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @var string
   */
  protected $block;

  /**
   * The row these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @var string
   */
  protected $row;

  /**
   * The seat this particular ticket is in if this performance is reserved. Empty otherwise.
   *
   * @var string
   */
  protected $seat;

  /**
   * The price of an individual ticket in this group (or simply the price of the ticket for reserved).
   *
   * @var double
   */
  protected $price;

  /**
   * Whether or not this performance is reserved.
   *
   * @var bool
   */
  protected $reserved;

  /**
   * Whether or not this ticket or these tickets have been refunded.
   *
   * @var bool
   */
  protected $refunded;

  /**
   * String of the form "(Bought under scheme : SchemeName)" or an empty string if this wasn't bought under a scheme
   *
   * @var string
   */
  protected $boughtUnderScheme;

  /**
   * The forename of the customer that has claimed / been gifted this ticket using a token
   *
   * @var string
   */
  protected $customerForename;

  /**
   * The surname of the customer that has claimed / been gifted this ticket using a token
   *
   * @var string
   */
  protected $customerSurname;

  /**
   * A List of `ViaApiTransactionFeeDetails` objects containing information on the outside fees that have been applied
   * to this group of tickets.
   *
   * @var \Red61\Via\DataObject\ViaApiTransactionFeeDetails[]
   */
  protected $fees;

  /**
   * Whether or not this ticket or these tickets are from a sub venue which has ETicket enabled accurate at point of
   * sale
   *
   * @var bool
   */
  protected $subVenueETicket;

  /**
   * the group of tickets gift aid applicable donation.
   *
   * @var double
   */
  protected $groupGiftAidDonation;

  /**
   * the applied value of all the fees for all tickets within the group.
   *
   * @var double
   */
  protected $groupFeeValue;

  /**
   * the applied tax value of all the fees for all tickets within the group.
   *
   * @var double
   */
  protected $groupFeeTaxValue;

  /**
   * The sum of the tickets only tax applicable to this group of tickets.
   *
   * @var double
   */
  protected $groupTicketTaxValue;

  /**
   * The sum of the tickets and fees tax applicable to this group of tickets.
   *
   * @var double
   */
  protected $groupTaxValue;

  /**
   * The current outstanding (including fee refunds) value of all the fees for all the tickets within the group.
   *
   * @var double
   */
  protected $outstandingGroupFeeValue;

  /**
   * The current outstanding (including fee refunds) tax value of all the fees for all the tickets within the group.
   *
   * @var double
   */
  protected $outstandingGroupFeeTaxValue;

  /**
   * Number of wheelchair users, if any, within this ticket group that will be attending the performance.
   *
   * @var int
   */
  protected $wheelchairUsersAttending;

  /**
   * The access note attached to the performance for all the tickets within the group.
   *
   * @var \Red61\Via\DataObject\ViaApiAccessNote
   */
  protected $accessNote;

  /**
   * URL where content for performance can be accessed.
   *
   * @var string
   */
  protected $contentUrl;

  /**
   * The format in which the performance will be presented to the customer : PHYSICAL, DIGITAL_OD, DIGITAL_LIVE or
   * DIGITAL_CATCHUP
   *
   * @var string
   */
  protected $presentationFormat;

  /**
   * The date that digital content for this performance is available in the form "yyyy-MM-dd HH:mm:ss". Note, can be
   * NULL for performances with no digital content. See the `java.text.SimpleDateFormat` documentation for information
   * on this format.
   *
   * @var string
   */
  protected $publishDateTime;

  /**
   * URL where catchup content for performance can be accessed.
   *
   * @var string
   */
  protected $catchupUrl;

  /**
   * The tags applied to the performance purchased by this ticket group
   *
   * @var \Red61\Via\DataObject\ViaApiTagDetails[]
   */
  protected $performanceTags;

  /**
   * The performance concession id of the concession these tickets have in the form "serverId:concessionId".
   *
   * @var string
   */
  protected $performanceConcessionId;

  /**
   * The price band concession id of the concession these tickets have in the form "serverId:concessionId".
   *
   * @var string
   */
  protected $pricebandConcessionId;

  /**
   * A list of the items for tickets in this group. Includes the `ViaApiTicketItemDetailsWithStatus#availableToScan`
   * field
   *
   * @var \Red61\Via\DataObject\ViaApiTicketItemDetailsWithStatus[]
   */
  protected $ticketItems;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'venue':
        return $this->getVenue();
      case 'venueId':
        return $this->getVenueId();
      case 'subvenue':
        return $this->getSubvenue();
      case 'subvenueId':
        return $this->getSubvenueId();
      case 'event':
        return $this->getEvent();
      case 'eventId':
        return $this->getEventId();
      case 'performance':
        return $this->getPerformance();
      case 'performanceId':
        return $this->getPerformanceId();
      case 'date':
        return $this->getDate();
      case 'quantity':
        return $this->getQuantity();
      case 'priceband':
        return $this->getPriceband();
      case 'performanceconcession':
        return $this->getPerformanceconcession();
      case 'pricebandconcession':
        return $this->getPricebandconcession();
      case 'performanceconcessioncode':
        return $this->getPerformanceconcessioncode();
      case 'pricebandconcessioncode':
        return $this->getPricebandconcessioncode();
      case 'area':
        return $this->getArea();
      case 'block':
        return $this->getBlock();
      case 'row':
        return $this->getRow();
      case 'seat':
        return $this->getSeat();
      case 'price':
        return $this->getPrice();
      case 'reserved':
        return $this->getReserved();
      case 'refunded':
        return $this->getRefunded();
      case 'boughtUnderScheme':
        return $this->getBoughtUnderScheme();
      case 'customerForename':
        return $this->getCustomerForename();
      case 'customerSurname':
        return $this->getCustomerSurname();
      case 'fees':
        return $this->getFees();
      case 'subVenueETicket':
        return $this->getSubVenueETicket();
      case 'groupGiftAidDonation':
        return $this->getGroupGiftAidDonation();
      case 'groupFeeValue':
        return $this->getGroupFeeValue();
      case 'groupFeeTaxValue':
        return $this->getGroupFeeTaxValue();
      case 'groupTicketTaxValue':
        return $this->getGroupTicketTaxValue();
      case 'groupTaxValue':
        return $this->getGroupTaxValue();
      case 'outstandingGroupFeeValue':
        return $this->getOutstandingGroupFeeValue();
      case 'outstandingGroupFeeTaxValue':
        return $this->getOutstandingGroupFeeTaxValue();
      case 'wheelchairUsersAttending':
        return $this->getWheelchairUsersAttending();
      case 'accessNote':
        return $this->getAccessNote();
      case 'contentUrl':
        return $this->getContentUrl();
      case 'presentationFormat':
        return $this->getPresentationFormat();
      case 'publishDateTime':
        return $this->getPublishDateTime();
      case 'catchupUrl':
        return $this->getCatchupUrl();
      case 'performanceTags':
        return $this->getPerformanceTags();
      case 'performanceConcessionId':
        return $this->getPerformanceConcessionId();
      case 'pricebandConcessionId':
        return $this->getPricebandConcessionId();
      case 'ticketItems':
        return $this->getTicketItems();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The venue title of the venue these tickets are for.
   *
   * @return string
   */
  public function getVenue()
  {
    return $this->venue;
  }


  /**
   * The venue reference of the venue these tickets are for in the form "serverId:venueId".
   *
   * @return string
   */
  public function getVenueId()
  {
    return $this->venueId;
  }


  /**
   * The subvenue title of the subvenue these tickets are for.
   *
   * @return string
   */
  public function getSubvenue()
  {
    return $this->subvenue;
  }


  /**
   * The subvenue reference of the subvenue these tickets are for in the form "serverId:subvenueId".
   *
   * @return string
   */
  public function getSubvenueId()
  {
    return $this->subvenueId;
  }


  /**
   * The event title of the event these tickets are for.
   *
   * @return string
   */
  public function getEvent()
  {
    return $this->event;
  }


  /**
   * The event reference of the event these tickets are for in the form "serverId:eventId".
   *
   * @return string
   */
  public function getEventId()
  {
    return $this->eventId;
  }


  /**
   * The performance title of the performance these tickets are for.
   *
   * @return string
   */
  public function getPerformance()
  {
    return $this->performance;
  }


  /**
   * The performance reference of the performance these tickets are for in the form "serverId:performanceId".
   *
   * @return string
   */
  public function getPerformanceId()
  {
    return $this->performanceId;
  }


  /**
   * The date of the performance these tickets are for in the form "yyyy-MM-dd HH:mm:ss". Note, can be NULL for Digital
   * on demand performances See the `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getDate()
  {
    return $this->date;
  }


  /**
   * The quantity of tickets.
   *
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }


  /**
   * The title of the price band these tickets are for.
   *
   * @return string
   */
  public function getPriceband()
  {
    return $this->priceband;
  }


  /**
   * The title of any performance concession applied to these tickets.
   *
   * @return string
   */
  public function getPerformanceconcession()
  {
    return $this->performanceconcession;
  }


  /**
   * The title of any price band concession applied to these tickets.
   *
   * @return string
   */
  public function getPricebandconcession()
  {
    return $this->pricebandconcession;
  }


  /**
   * The code of any performance concession applied to these tickets.
   *
   * @return string
   */
  public function getPerformanceconcessioncode()
  {
    return $this->performanceconcessioncode;
  }


  /**
   * The code of any price band concession applied to these tickets.
   *
   * @return string
   */
  public function getPricebandconcessioncode()
  {
    return $this->pricebandconcessioncode;
  }


  /**
   * The area these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @return string
   */
  public function getArea()
  {
    return $this->area;
  }


  /**
   * The block these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @return string
   */
  public function getBlock()
  {
    return $this->block;
  }


  /**
   * The row these tickets are in if this performance is reserved. Empty otherwise.
   *
   * @return string
   */
  public function getRow()
  {
    return $this->row;
  }


  /**
   * The seat this particular ticket is in if this performance is reserved. Empty otherwise.
   *
   * @return string
   */
  public function getSeat()
  {
    return $this->seat;
  }


  /**
   * The price of an individual ticket in this group (or simply the price of the ticket for reserved).
   *
   * @return double
   */
  public function getPrice()
  {
    return $this->price;
  }


  /**
   * Whether or not this performance is reserved.
   *
   * @return bool
   */
  public function getReserved()
  {
    return $this->reserved;
  }


  /**
   * Whether or not this ticket or these tickets have been refunded.
   *
   * @return bool
   */
  public function getRefunded()
  {
    return $this->refunded;
  }


  /**
   * String of the form "(Bought under scheme : SchemeName)" or an empty string if this wasn't bought under a scheme
   *
   * @return string
   */
  public function getBoughtUnderScheme()
  {
    return $this->boughtUnderScheme;
  }


  /**
   * The forename of the customer that has claimed / been gifted this ticket using a token
   *
   * @return string
   */
  public function getCustomerForename()
  {
    return $this->customerForename;
  }


  /**
   * The surname of the customer that has claimed / been gifted this ticket using a token
   *
   * @return string
   */
  public function getCustomerSurname()
  {
    return $this->customerSurname;
  }


  /**
   * A List of `ViaApiTransactionFeeDetails` objects containing information on the outside fees that have been applied
   * to this group of tickets.
   *
   * @return \Red61\Via\DataObject\ViaApiTransactionFeeDetails[]
   */
  public function getFees()
  {
	return $this->fees ? : array();
  }


  /**
   * Whether or not this ticket or these tickets are from a sub venue which has ETicket enabled accurate at point of
   * sale
   *
   * @return bool
   */
  public function getSubVenueETicket()
  {
    return $this->subVenueETicket;
  }


  /**
   * the group of tickets gift aid applicable donation.
   *
   * @return double
   */
  public function getGroupGiftAidDonation()
  {
    return $this->groupGiftAidDonation;
  }


  /**
   * the applied value of all the fees for all tickets within the group.
   *
   * @return double
   */
  public function getGroupFeeValue()
  {
    return $this->groupFeeValue;
  }


  /**
   * the applied tax value of all the fees for all tickets within the group.
   *
   * @return double
   */
  public function getGroupFeeTaxValue()
  {
    return $this->groupFeeTaxValue;
  }


  /**
   * The sum of the tickets only tax applicable to this group of tickets.
   *
   * @return double
   */
  public function getGroupTicketTaxValue()
  {
    return $this->groupTicketTaxValue;
  }


  /**
   * The sum of the tickets and fees tax applicable to this group of tickets.
   *
   * @return double
   */
  public function getGroupTaxValue()
  {
    return $this->groupTaxValue;
  }


  /**
   * The current outstanding (including fee refunds) value of all the fees for all the tickets within the group.
   *
   * @return double
   */
  public function getOutstandingGroupFeeValue()
  {
    return $this->outstandingGroupFeeValue;
  }


  /**
   * The current outstanding (including fee refunds) tax value of all the fees for all the tickets within the group.
   *
   * @return double
   */
  public function getOutstandingGroupFeeTaxValue()
  {
    return $this->outstandingGroupFeeTaxValue;
  }


  /**
   * Number of wheelchair users, if any, within this ticket group that will be attending the performance.
   *
   * @return int
   */
  public function getWheelchairUsersAttending()
  {
    return $this->wheelchairUsersAttending;
  }


  /**
   * The access note attached to the performance for all the tickets within the group.
   *
   * @return \Red61\Via\DataObject\ViaApiAccessNote
   */
  public function getAccessNote()
  {
    return $this->accessNote;
  }


  /**
   * URL where content for performance can be accessed.
   *
   * @return string
   */
  public function getContentUrl()
  {
    return $this->contentUrl;
  }


  /**
   * The format in which the performance will be presented to the customer : PHYSICAL, DIGITAL_OD, DIGITAL_LIVE or
   * DIGITAL_CATCHUP
   *
   * @return string
   */
  public function getPresentationFormat()
  {
    return $this->presentationFormat;
  }


  /**
   * The date that digital content for this performance is available in the form "yyyy-MM-dd HH:mm:ss". Note, can be
   * NULL for performances with no digital content. See the `java.text.SimpleDateFormat` documentation for information
   * on this format.
   *
   * @return string
   */
  public function getPublishDateTime()
  {
    return $this->publishDateTime;
  }


  /**
   * URL where catchup content for performance can be accessed.
   *
   * @return string
   */
  public function getCatchupUrl()
  {
    return $this->catchupUrl;
  }


  /**
   * The tags applied to the performance purchased by this ticket group
   *
   * @return \Red61\Via\DataObject\ViaApiTagDetails[]
   */
  public function getPerformanceTags()
  {
	return $this->performanceTags ? : array();
  }


  /**
   * The performance concession id of the concession these tickets have in the form "serverId:concessionId".
   *
   * @return string
   */
  public function getPerformanceConcessionId()
  {
    return $this->performanceConcessionId;
  }


  /**
   * The price band concession id of the concession these tickets have in the form "serverId:concessionId".
   *
   * @return string
   */
  public function getPricebandConcessionId()
  {
    return $this->pricebandConcessionId;
  }


  /**
   * A list of the items for tickets in this group. Includes the `ViaApiTicketItemDetailsWithStatus#availableToScan`
   * field
   *
   * @return \Red61\Via\DataObject\ViaApiTicketItemDetailsWithStatus[]
   */
  public function getTicketItems()
  {
	return $this->ticketItems ? : array();
  }


}
