<?php
/**
 * Defines the RawapiSendMotoPaymentReturnRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method uses the given paymentMethod request Id and takes payment for the remaining basket amount and completes
 * the order.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSendMotoPaymentReturnRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSendMotoPaymentReturnRequest.
 */
abstract class RawapiSendMotoPaymentReturnRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSendMotoPaymentReturn';

  /**
   * - Id of the card payment data provided by the processor.
   *
   * @var string
   */
  protected $requestId;

  /**
   * - the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * - Id of the card payment data provided by the processor.
   *
   * @return string
   */
  public function getRequestId()
  {
    return $this->requestId;
  }


  /**
   * - Id of the card payment data provided by the processor.
   *
   * @param string $requestId
   *
   * @return $this
   */
  public function setRequestId($requestId)
  {
    $this->requestId = $requestId;
    return $this;
  }

  /**
   * - the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * - the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
