<?php
/**
 * Defines the RawapiCreateMotoOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method takes a non-api basket and provides MOTO payment form html for display to allow the Payment Service
 * Provider to capture the card details. Card Details are captured and send directly to the Payment Service Provider, so
 * this method may be used to provide solution where website hosting does not need to be PCI:DSS complaint
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateMotoOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateMotoOrderRequest.
 */
abstract class RawapiCreateMotoOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateMotoOrder';

  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiTakeMotoPayment`
   *
   * @var string
   */
  protected $successURL;

  /**
   * URL the payment processor should to redirect to after a failed payment (if supported)
   *
   * @var string
   */
  protected $failURL;

  /**
   * the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiTakeMotoPayment`
   *
   * @return string
   */
  public function getSuccessURL()
  {
    return $this->successURL;
  }


  /**
   * URL the payment processor should to redirect to after a successful payment (if supported), Typically this page
   * would also make the call to `apiTakeMotoPayment`
   *
   * @param string $successURL
   *
   * @return $this
   */
  public function setSuccessURL($successURL)
  {
    $this->successURL = $successURL;
    return $this;
  }

  /**
   * URL the payment processor should to redirect to after a failed payment (if supported)
   *
   * @return string
   */
  public function getFailURL()
  {
    return $this->failURL;
  }


  /**
   * URL the payment processor should to redirect to after a failed payment (if supported)
   *
   * @param string $failURL
   *
   * @return $this
   */
  public function setFailURL($failURL)
  {
    $this->failURL = $failURL;
    return $this;
  }

  /**
   * the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, currently this method is only compatible with NON web baskets.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
