<?php
/**
 * Defines the RawapiSetDeliveryOptionRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Set the delivery option, and the selected delivery fees for each given item type
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiSetDeliveryOptionRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiSetDeliveryOptionRequest.
 */
abstract class RawapiSetDeliveryOptionRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiSetDeliveryOption';

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * The id of delivery option to select
   *
   * @var int
   */
  protected $deliveryOptionId;

  /**
   * The list of selected fees for each item type
   *
   * @var \Red61\Via\DataObject\ViaApiFeeForItemType[]
   */
  protected $deliveryFees;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * The Id for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * The id of delivery option to select
   *
   * @return int
   */
  public function getDeliveryOptionId()
  {
    return $this->deliveryOptionId;
  }


  /**
   * The id of delivery option to select
   *
   * @param int $deliveryOptionId
   *
   * @return $this
   */
  public function setDeliveryOptionId($deliveryOptionId)
  {
    $this->deliveryOptionId = $deliveryOptionId;
    return $this;
  }

  /**
   * The list of selected fees for each item type
   *
   * @return \Red61\Via\DataObject\ViaApiFeeForItemType[]
   */
  public function getDeliveryFees()
  {
    return $this->deliveryFees;
  }


  /**
   * The list of selected fees for each item type
   *
   * @param \Red61\Via\DataObject\ViaApiFeeForItemType[] $deliveryFees
   *
   * @return $this
   */
  public function setDeliveryFees($deliveryFees)
  {
    $this->deliveryFees = $deliveryFees;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
