<?php
/**
 * Defines the RawapiCreateOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Creates the entire order => order record, line items and processes payment. Processes the payment using the relevant
 * Payment Processor linked to the WEB location. If the transaction total is ZERO (items + handling and postage fee)
 * then the card processing is bypassed and a complimentary payment is created instead. Currently though card fields are
 * required for a complimentary payment so pass in `4111111111111111` as the card number, a valid expiry date and any
 * three digit cv2 number (123 for example). This will pass the card checking.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiCreateOrderRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiCreateOrderRequest.
 */
abstract class RawapiCreateOrderRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest,
		\Red61\Via\ApiRequest\BasketIdRequiredRequest {


  const SOAP_METHOD_NAME = 'apiCreateOrder';

  /**
   * the card holder's name.
   *
   * @var string
   */
  protected $ccName;

  /**
   * the Primary Account Number without spaces.
   *
   * @var string
   */
  protected $ccNumber;

  /**
   * start date of the form "MM/YY" if available.
   *
   * @var string
   */
  protected $startDate;

  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @var string
   */
  protected $expiryDate;

  /**
   * issue number if available.
   *
   * @var string
   */
  protected $issue;

  /**
   * the security no on back of card.
   *
   * @var string
   */
  protected $cv2;

  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @var string
   */
  protected $workstationId;

  /**
   * `0` to indicate that the order will be collected at the box office, `1` to indicate that the tickets will be posted
   * out to the customers primary address, `2` to indicate that the tickets will be posted to the customers alternative
   * address.
   *
   * @var int
   */
  protected $deliveryOption;

  /**
   * ID representing the customer making this payment.
   *
   * @var int
   */
  protected $customerId;

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @var string
   */
  protected $sessionId;

  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @var int
   */
  protected $browserType;

  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @var string
   */
  protected $userAgent;

  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @var string
   */
  protected $acceptHeaders;

  /**
   * Should the card details be saved for future purchases
   *
   * @var bool
   */
  protected $saveCardDetails;

  /**
   * authentication token to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * the card holder's name.
   *
   * @return string
   */
  public function getCcName()
  {
    return $this->ccName;
  }


  /**
   * the card holder's name.
   *
   * @param string $ccName
   *
   * @return $this
   */
  public function setCcName($ccName)
  {
    $this->ccName = $ccName;
    return $this;
  }

  /**
   * the Primary Account Number without spaces.
   *
   * @return string
   */
  public function getCcNumber()
  {
    return $this->ccNumber;
  }


  /**
   * the Primary Account Number without spaces.
   *
   * @param string $ccNumber
   *
   * @return $this
   */
  public function setCcNumber($ccNumber)
  {
    $this->ccNumber = $ccNumber;
    return $this;
  }

  /**
   * start date of the form "MM/YY" if available.
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * start date of the form "MM/YY" if available.
   *
   * @param string $startDate
   *
   * @return $this
   */
  public function setStartDate($startDate)
  {
    $this->startDate = $startDate;
    return $this;
  }

  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @return string
   */
  public function getExpiryDate()
  {
    return $this->expiryDate;
  }


  /**
   * expiry date of the form "MM/YY" if available.
   *
   * @param string $expiryDate
   *
   * @return $this
   */
  public function setExpiryDate($expiryDate)
  {
    $this->expiryDate = $expiryDate;
    return $this;
  }

  /**
   * issue number if available.
   *
   * @return string
   */
  public function getIssue()
  {
    return $this->issue;
  }


  /**
   * issue number if available.
   *
   * @param string $issue
   *
   * @return $this
   */
  public function setIssue($issue)
  {
    $this->issue = $issue;
    return $this;
  }

  /**
   * the security no on back of card.
   *
   * @return string
   */
  public function getCv2()
  {
    return $this->cv2;
  }


  /**
   * the security no on back of card.
   *
   * @param string $cv2
   *
   * @return $this
   */
  public function setCv2($cv2)
  {
    $this->cv2 = $cv2;
    return $this;
  }

  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @return string
   */
  public function getWorkstationId()
  {
    return $this->workstationId;
  }


  /**
   * the webserver hostname making this payment if available. Note: max chars 20, so you may need to truncate
   *
   * @param string $workstationId
   *
   * @return $this
   */
  public function setWorkstationId($workstationId)
  {
    $this->workstationId = $workstationId;
    return $this;
  }

  /**
   * `0` to indicate that the order will be collected at the box office, `1` to indicate that the tickets will be posted
   * out to the customers primary address, `2` to indicate that the tickets will be posted to the customers alternative
   * address.
   *
   * @return int
   */
  public function getDeliveryOption()
  {
    return $this->deliveryOption;
  }


  /**
   * `0` to indicate that the order will be collected at the box office, `1` to indicate that the tickets will be posted
   * out to the customers primary address, `2` to indicate that the tickets will be posted to the customers alternative
   * address.
   *
   * @param int $deliveryOption
   *
   * @return $this
   */
  public function setDeliveryOption($deliveryOption)
  {
    $this->deliveryOption = $deliveryOption;
    return $this;
  }

  /**
   * ID representing the customer making this payment.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer making this payment.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @return string
   */
  public function getSessionId()
  {
    return $this->sessionId;
  }


  /**
   * the ID for the basket being used, see `apiGetBasketSessionId`.
   *
   * @param string $sessionId
   *
   * @return $this
   */
  public function setSessionId($sessionId)
  {
    $this->sessionId = $sessionId;
    return $this;
  }

  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @return int
   */
  public function getBrowserType()
  {
    return $this->browserType;
  }


  /**
   * 3D secure required field, indicates the type of device used for the transaction, possible values are 0 for PC and 1
   * for mobile device.
   *
   * @param int $browserType
   *
   * @return $this
   */
  public function setBrowserType($browserType)
  {
    $this->browserType = $browserType;
    return $this;
  }

  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @return string
   */
  public function getUserAgent()
  {
    return $this->userAgent;
  }


  /**
   * 3D secure required field, the user agent associated with the device.
   *
   * @param string $userAgent
   *
   * @return $this
   */
  public function setUserAgent($userAgent)
  {
    $this->userAgent = $userAgent;
    return $this;
  }

  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @return string
   */
  public function getAcceptHeaders()
  {
    return $this->acceptHeaders;
  }


  /**
   * 3D secure required field, The MIME types of the headers accepted by this device.
   *
   * @param string $acceptHeaders
   *
   * @return $this
   */
  public function setAcceptHeaders($acceptHeaders)
  {
    $this->acceptHeaders = $acceptHeaders;
    return $this;
  }

  /**
   * Should the card details be saved for future purchases
   *
   * @return bool
   */
  public function getSaveCardDetails()
  {
    return $this->saveCardDetails;
  }


  /**
   * Should the card details be saved for future purchases
   *
   * @param bool $saveCardDetails
   *
   * @return $this
   */
  public function setSaveCardDetails($saveCardDetails)
  {
    $this->saveCardDetails = $saveCardDetails;
    return $this;
  }

  /**
   * authentication token to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * authentication token to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
