<?php
/**
 * Defines the RawapiGetCustomerSchemeUsagesRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to retrieve a `ViaApiSchemeUsageDetails` object containing information on the number and details
 * of discounted tickets for the customer's subscription
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerSchemeUsagesRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerSchemeUsagesRequest.
 */
abstract class RawapiGetCustomerSchemeUsagesRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerSchemeUsages';

  /**
   * The id of the customer
   *
   * @var int
   */
  protected $customerId;

  /**
   * The reference for the scheme, of the form serverId:schemeId
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * 
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * The id of the customer
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * The id of the customer
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The reference for the scheme, of the form serverId:schemeId
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The reference for the scheme, of the form serverId:schemeId
   *
   * @param string $schemeRef
   *
   * @return $this
   */
  public function setSchemeRef($schemeRef)
  {
    $this->schemeRef = $schemeRef;
    return $this;
  }

  /**
   * 
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * 
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
