<?php
/**
 * Defines the RawViaApiSchemeTierDetails data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * ViaApiSchemeTierDetails is based on ViaApiSchemeDetails but extended to include data that can be used to identify the
 * selected scheme tier
 * 
 * Addtional fields required by the tier are:
 * 
 * - performanceEventLimit - limit on the number of event or performances for scheme benefits. See
 * `performanceEventLimit` for an example.
 * - maxCountContext - the context (event or performance) for the use of the limits (both maxPerPerformanceEvent and
 * performanceEventLimit)
 * - maxPerPerformanceEvent - The limit per a particular event or performance. See `maxPerPerformanceEvent` for an
 * example.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiSchemeTierDetails.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiSchemeTierDetails.
 */
abstract class RawViaApiSchemeTierDetails {

  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @var string
   */
  protected $schemeRef;

  /**
   * The title of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $title;

  /**
   * The code of the scheme this tier is a member of.
   *
   * @var string
   */
  protected $code;

  /**
   * The notes on the scheme this tier is a member of.
   *
   * @var string
   */
  protected $notes;

  /**
   * The start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $startDate;

  /**
   * The end date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $endDate;

  /**
   * The priority start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $priorityStartDate;

  /**
   * The priority end date of the scheme this tier is a member ofin the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @var string
   */
  protected $priorityEndDate;

  /**
   * The gift aid declaration text.
   *
   * @var string
   */
  protected $giftAidText;

  /**
   * The limit on the number of concessions in a particular event or performance. I.e. a limit of 5 on performance would
   * mean that a customer can only have the benefit of up to 5 concessions for a particular performance. The
   * `maxCountContext` field determines event or performance.
   *
   * @var int
   */
  protected $maxPerPerformanceEvent;

  /**
   * The cost for this scheme tier.
   *
   * @var double
   */
  protected $fee;

  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @var string
   */
  protected $tierId;

  /**
   * The limit on the number of events or performances that these concessions can apply to. I.e. A limit of 5 on
   * performances means a customer can only use the concessions The `maxCountContext` field determines event or
   * performance.
   *
   * @var int
   */
  protected $performanceEventLimit;

  /**
   * The title of this scheme tier.
   *
   * @var string
   */
  protected $tierTitle;

  /**
   * 
   *
   * @var string
   */
  protected $maxCountContext;

  /**
   * Any concessions which can be applied to purchasing this scheme tier.
   *
   * @var \Red61\Via\DataObject\ViaApiSchemeTierConcessionDetails[]
   */
  protected $concessions;

  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @var bool
   */
  protected $isGiftAidable;

  /**
   * The gift aidable value of this scheme tier.
   *
   * @var double
   */
  protected $donationValue;

  /**
   * The item id of this subscription in this transaction
   *
   * @var int
   */
  protected $itemId;

  /**
   * whether this subscription has been refunded
   *
   * @var bool
   */
  protected $refunded;

  /**
   * The forename of the customer that has claimed / been gifted this subscription using a token
   *
   * @var string
   */
  protected $customerForename;

  /**
   * The surname of the customer that has claimed / been gifted this subscription using a token
   *
   * @var string
   */
  protected $customerSurname;

  /**
   * The code of this scheme tier.
   *
   * @var string
   */
  protected $tierCode;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'schemeRef':
        return $this->getSchemeRef();
      case 'title':
        return $this->getTitle();
      case 'code':
        return $this->getCode();
      case 'notes':
        return $this->getNotes();
      case 'startDate':
        return $this->getStartDate();
      case 'endDate':
        return $this->getEndDate();
      case 'priorityStartDate':
        return $this->getPriorityStartDate();
      case 'priorityEndDate':
        return $this->getPriorityEndDate();
      case 'giftAidText':
        return $this->getGiftAidText();
      case 'maxPerPerformanceEvent':
        return $this->getMaxPerPerformanceEvent();
      case 'fee':
        return $this->getFee();
      case 'tierId':
        return $this->getTierId();
      case 'performanceEventLimit':
        return $this->getPerformanceEventLimit();
      case 'tierTitle':
        return $this->getTierTitle();
      case 'maxCountContext':
        return $this->getMaxCountContext();
      case 'concessions':
        return $this->getConcessions();
      case 'isGiftAidable':
        return $this->getIsGiftAidable();
      case 'donationValue':
        return $this->getDonationValue();
      case 'itemId':
        return $this->getItemId();
      case 'refunded':
        return $this->getRefunded();
      case 'customerForename':
        return $this->getCustomerForename();
      case 'customerSurname':
        return $this->getCustomerSurname();
      case 'tierCode':
        return $this->getTierCode();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * The reference of the scheme this tier is a member of in the form "serverId:schemeId"
   *
   * @return string
   */
  public function getSchemeRef()
  {
    return $this->schemeRef;
  }


  /**
   * The title of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }


  /**
   * The code of the scheme this tier is a member of.
   *
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }


  /**
   * The notes on the scheme this tier is a member of.
   *
   * @return string
   */
  public function getNotes()
  {
    return $this->notes;
  }


  /**
   * The start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getStartDate()
  {
    return $this->startDate;
  }


  /**
   * The end date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getEndDate()
  {
    return $this->endDate;
  }


  /**
   * The priority start date of the scheme this tier is a member of in the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getPriorityStartDate()
  {
    return $this->priorityStartDate;
  }


  /**
   * The priority end date of the scheme this tier is a member ofin the form "yyyy-MM-dd HH:mm:ss". See the
   * `java.text.SimpleDateFormat` documentation for information on this format.
   *
   * @return string
   */
  public function getPriorityEndDate()
  {
    return $this->priorityEndDate;
  }


  /**
   * The gift aid declaration text.
   *
   * @return string
   */
  public function getGiftAidText()
  {
    return $this->giftAidText;
  }


  /**
   * The limit on the number of concessions in a particular event or performance. I.e. a limit of 5 on performance would
   * mean that a customer can only have the benefit of up to 5 concessions for a particular performance. The
   * `maxCountContext` field determines event or performance.
   *
   * @return int
   */
  public function getMaxPerPerformanceEvent()
  {
    return $this->maxPerPerformanceEvent;
  }


  /**
   * The cost for this scheme tier.
   *
   * @return double
   */
  public function getFee()
  {
    return $this->fee;
  }


  /**
   * The reference for the actual tier in the form "serverId:schemeId:tierId".
   *
   * @return string
   */
  public function getTierId()
  {
    return $this->tierId;
  }


  /**
   * The limit on the number of events or performances that these concessions can apply to. I.e. A limit of 5 on
   * performances means a customer can only use the concessions The `maxCountContext` field determines event or
   * performance.
   *
   * @return int
   */
  public function getPerformanceEventLimit()
  {
    return $this->performanceEventLimit;
  }


  /**
   * The title of this scheme tier.
   *
   * @return string
   */
  public function getTierTitle()
  {
    return $this->tierTitle;
  }


  /**
   * 
   *
   * @return string
   */
  public function getMaxCountContext()
  {
    return $this->maxCountContext;
  }


  /**
   * Any concessions which can be applied to purchasing this scheme tier.
   *
   * @return \Red61\Via\DataObject\ViaApiSchemeTierConcessionDetails[]
   */
  public function getConcessions()
  {
	return $this->concessions ? : array();
  }


  /**
   * Whether or not this scheme tier is gift aidable.
   *
   * @return bool
   */
  public function getIsGiftAidable()
  {
    return $this->isGiftAidable;
  }


  /**
   * The gift aidable value of this scheme tier.
   *
   * @return double
   */
  public function getDonationValue()
  {
    return $this->donationValue;
  }


  /**
   * The item id of this subscription in this transaction
   *
   * @return int
   */
  public function getItemId()
  {
    return $this->itemId;
  }


  /**
   * whether this subscription has been refunded
   *
   * @return bool
   */
  public function getRefunded()
  {
    return $this->refunded;
  }


  /**
   * The forename of the customer that has claimed / been gifted this subscription using a token
   *
   * @return string
   */
  public function getCustomerForename()
  {
    return $this->customerForename;
  }


  /**
   * The surname of the customer that has claimed / been gifted this subscription using a token
   *
   * @return string
   */
  public function getCustomerSurname()
  {
    return $this->customerSurname;
  }


  /**
   * The code of this scheme tier.
   *
   * @return string
   */
  public function getTierCode()
  {
    return $this->tierCode;
  }


}
