<?php
/**
 * Defines the RawapiGetCustomerConsentQuestionsRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * Fetch all answered data protection consent questions for a customer, with their given answers. Optionally return any
 * additional un-answered questions for this customer.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiGetCustomerConsentQuestionsRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiGetCustomerConsentQuestionsRequest.
 */
abstract class RawapiGetCustomerConsentQuestionsRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiGetCustomerConsentQuestions';

  /**
   * customer to look up questions and answers for
   *
   * @var int
   */
  protected $customerId;

  /**
   * If true, any new or currently un-answered questions for the customer will also be returned
   *
   * @var bool
   */
  protected $includeUnanswered;

  /**
   * The authentication code
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * customer to look up questions and answers for
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * customer to look up questions and answers for
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * If true, any new or currently un-answered questions for the customer will also be returned
   *
   * @return bool
   */
  public function getIncludeUnanswered()
  {
    return $this->includeUnanswered;
  }


  /**
   * If true, any new or currently un-answered questions for the customer will also be returned
   *
   * @param bool $includeUnanswered
   *
   * @return $this
   */
  public function setIncludeUnanswered($includeUnanswered)
  {
    $this->includeUnanswered = $includeUnanswered;
    return $this;
  }

  /**
   * The authentication code
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
