<?php
/**
 * Defines the apiCreateOrderRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\ApiRequest;

/**
 * @package    Red61\Via\ApiRequest
 * {@inheritdoc}
 */
class apiCreateOrderRequest
	extends \Red61\Via\RawGenerated\ApiRequest\RawapiCreateOrderRequest
	implements OrderCompletingRequest {

	/**
	 * Sets the value, truncating to 20 characters
	 * {@inheritdoc}
	 */
	public function setWorkstationId($workstationId)
	{
		return parent::setWorkstationId(substr($workstationId, 0, 20));
	}

}
