<?php
/**
 * Defines apiLoginRequestSpec - specifications for Red61\Via\ApiRequest\apiLoginRequest
 *
 * @copyright  2014 Red61 Ltd
 * @licence    proprietary
 */

namespace spec\Red61\Via\ApiRequest;

use PhpSpec\Exception\Example\FailureException;
use Red61\Via\Exception\ClientInvalidRequestException;
use spec\ObjectBehavior;
use Prophecy\Argument;

/**
 *
 * @see Red61\Via\ApiRequest\apiLoginRequest
 */
class apiLoginRequestSpec extends ObjectBehavior
{
    /**
     * Use $this->subject to get proper type hinting for the subject class
     * @var \Red61\Via\ApiRequest\apiLoginRequest
     */
	protected $subject;

	function it_is_initializable()
    {
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\apiLoginRequest');
	}

	function it_is_a_preflight_filtering_request()
	{
		$this->subject->shouldHaveType('Red61\Via\ApiRequest\PreflightFilteringRequest');
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 */
	function it_does_not_throw_preflight_with_valid_params($notification)
	{
		$this->subject
			->setEmail('me@somewhere.com')
			->setPassword('pw')
			->onBeforeViaCall($notification);
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 *
	 * @throws \PhpSpec\Exception\Example\FailureException
	 */
	function it_throws_preflight_if_email_not_set($notification)
	{
		try {
			$this->subject->setPassword('pw')->onBeforeViaCall($notification);
			throw new FailureException("Expected exception not thrown");
		} catch (ClientInvalidRequestException $e)
		{
			expect($e->getInvalidParameters())->toHaveKey('email');
		}
	}

	/**
	 * @param \Red61\Via\Plugin\ViaApiCallNotification $notification
	 *
	 * @throws \PhpSpec\Exception\Example\FailureException
	 */
	function it_throws_preflight_if_password_not_set($notification)
	{
		try {
			$this->subject->setEmail('me@somewhere.com')->onBeforeViaCall($notification);
			throw new FailureException("Expected exception not thrown");
		} catch (ClientInvalidRequestException $e)
		{
			expect($e->getInvalidParameters())->toHaveKey('password');
		}
	}
}
