<?php
/**
* Defines the InvalidExceptionMappingException
*
* @author    Red61 Ltd
* @copyright Red61 Ltd
* @licence   proprietary
*/

namespace Red61\Via\Exception;


/**
 * Thrown if a SoapFault is thrown during a VIA request and the class mapping in
 * ViaExceptionMapper referred to a class that does not exist.
 *
 * This is most likely because you have customised the exception mapping and either not created
 * the expected exception class, not placed it where your autoloader can find it, or made
 * a typo in the mapping definition or class name.
 *
 * [!!] This exception extends \SoapFault for legacy compatibility reasons, but is likely
 *      in future to change to extend \InvalidArgumentException or a similar runtime exception
 *      class.
 *
 *
 * @see \Red61\Via\Exception\ViaExceptionMaper::map
 */
class InvalidExceptionMappingException extends \SoapFault implements ViaException {
}
