<?php
/**
 * Defines the RawViaApiTicketAttributeSelection data object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\DataObject;
use \Red61\Via\ViaApiClient;
/**
 * Represents the attribute selection in `ViaApiTicketAttributeRequest#attributeSelection` for
 * `apiAddTicketsWithAttributesToBasket` This defines what combination of mandatory and/or optional attribute types the
 * selected seats must have. The way the system searches for seats with the `optionalAttributes` can be changed using
 * the flags provided.
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\DataObject\ViaApiTicketAttributeSelection.
 *
 * @package    Red61\Via\RawGenerated\DataObject
 * @see        \Red61\Via\DataObject\ViaApiTicketAttributeSelection.
 */
#[\AllowDynamicProperties]
abstract class RawViaApiTicketAttributeSelection {

  /**
   * If specified, the seats selected must include this single mandatory attribute, unless overridden by
   * `allowGeneralSale`.
   * 
   * Can be `null`
   *
   * @var \Red61\Via\DataObject\ViaApiTicketAttribute
   */
  protected $mandatoryAttribute;

  /**
   * If specified, the seats selected must have these optional attributes, unless overridden by `allowGeneralSale`,
   * `allowAnySelectedOptionalAttributes` or `allowAnySelectedOptionalAttributes`.
   * 
   * Can be empty or `null`
   *
   * @var \Red61\Via\DataObject\ViaApiTicketAttribute[]
   */
  protected $optionalAttributes;

  /**
   * Include seats which match the `mandatoryAttribute` and `optionalAttributes` selection but have other optional
   * attributes not specified in `optionalAttributes`
   *
   * @var bool
   */
  protected $allowOtherOptionalAttributes;

  /**
   * Include seats from general sale (seats with no attributes), in addition to seats which match selection of
   * `mandatoryAttribute` and `optionalAttributes`
   *
   * @var bool
   */
  protected $allowGeneralSale;

  /**
   * Include seats which have any (one or more) of the selected `optionalAttributes`, rather than requiring them all.
   *
   * @var bool
   */
  protected $allowAnySelectedOptionalAttributes;

  /**
   * Include seats which have no `optionalAttributes`. Must still have any selected `mandatoryAttribute`
   *
   * @var bool
   */
  protected $allowNoOptionalAttributes;

  /**
   * Provides access to protected response properties in backwards compatible mode.
   *
   * Direct property access is deprecated, with getter access preferred for new projects. This method bridges the gap,
   * optionally logging any last property access in a project. For new code or once an existing application is migrated,
   * you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   *
   * @return mixed
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __get($field) {
    if ($field === 'any') {
      // php-soap attempts to read this field if it thinks there is a mismatch between the wsdl and the returned object
      return NULL;
    }

    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use the getter method, or set ViaApiClient::$object_compatibility_mode to enable protected field access'
      );
    }
    
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be accessed directly, use the getter method instead',
        E_USER_NOTICE
      );
    }
    
    switch ($field)
    {
      case 'mandatoryAttribute':
        return $this->getMandatoryAttribute();
      case 'optionalAttributes':
        return $this->getOptionalAttributes();
      case 'allowOtherOptionalAttributes':
        return $this->getAllowOtherOptionalAttributes();
      case 'allowGeneralSale':
        return $this->getAllowGeneralSale();
      case 'allowAnySelectedOptionalAttributes':
        return $this->getAllowAnySelectedOptionalAttributes();
      case 'allowNoOptionalAttributes':
        return $this->getAllowNoOptionalAttributes();
      default:
        throw new \BadMethodCallException('Undefined property '.$prop);
    }
  }

  /**
   * Provides access to set protected response properties in backwards compatible mode.
   *
   * Setting or overwriting properties of VIA response objects is deprecated, as these objects are intended to be
   * immutable - overwriting the values provided by VIA may cause unexpected results now or in future.
   *
   * This method bridges the gap, optionally logging any property assignment in the project. For new code or once an
   * existing application is migrated, you should set ViaApiClient::$object_compatibility_mode to throw exceptions.
   *
   * @param string $field the property to get
   * @param mixed  $value the value to set
   *
   * @return void
   * @throws \BadMethodCallException if the property doesn't exist or object compatibility is disabled
   */
  public function __set($field, $value) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Set ViaApiClient::$object_compatibility_mode if you want to enable protected field access'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be overwritten',
        E_USER_NOTICE
      );
    }

    $this->$field = $value;
  }

  /**
   * Supports use of isset to detect whether a property is defined on a VIA object
   *
   * Accessing VIA response object properties directly is deprecated - treating them as immutable objects and using
   * the getter methods is preferred.
   *
   * Use of isset is also discouraged, because it can produce unexpected results depending on the value returned by
   * VIA. For example, instead of `if(isset($basket->events))` we recommend simply `if($basket->getEvents())`.
   *
   * @param string $field the property to check
   *
   * @return bool
   * @throws \BadMethodCallException if object compatibility is disabled
   */
  public function __isset($field) {
    $prop = sprintf('%s->%s', get_class($this), $field);
    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_OFF) {
      throw new \BadMethodCallException(
        'Property '.$prop.' is not accessible'.\PHP_EOL.\PHP_EOL.
        'Use getters rather than testing property existence with isset'
      );
    }

    if (ViaApiClient::$object_compatibility_mode === ViaApiClient::OBJECT_COMPATIBILITY_WARN) {
      trigger_error(
        'Property '.$prop.' should not be tested with isset - use getters instead',
        E_USER_NOTICE
      );
    }

    return isset($this->$field);
  }



  /**
   * If specified, the seats selected must include this single mandatory attribute, unless overridden by
   * `allowGeneralSale`.
   * 
   * Can be `null`
   *
   * @return \Red61\Via\DataObject\ViaApiTicketAttribute
   */
  public function getMandatoryAttribute()
  {
    return $this->mandatoryAttribute;
  }


  /**
   * If specified, the seats selected must have these optional attributes, unless overridden by `allowGeneralSale`,
   * `allowAnySelectedOptionalAttributes` or `allowAnySelectedOptionalAttributes`.
   * 
   * Can be empty or `null`
   *
   * @return \Red61\Via\DataObject\ViaApiTicketAttribute[]
   */
  public function getOptionalAttributes()
  {
	return $this->optionalAttributes ? : array();
  }


  /**
   * Include seats which match the `mandatoryAttribute` and `optionalAttributes` selection but have other optional
   * attributes not specified in `optionalAttributes`
   *
   * @return bool
   */
  public function getAllowOtherOptionalAttributes()
  {
    return $this->allowOtherOptionalAttributes;
  }


  /**
   * Include seats from general sale (seats with no attributes), in addition to seats which match selection of
   * `mandatoryAttribute` and `optionalAttributes`
   *
   * @return bool
   */
  public function getAllowGeneralSale()
  {
    return $this->allowGeneralSale;
  }


  /**
   * Include seats which have any (one or more) of the selected `optionalAttributes`, rather than requiring them all.
   *
   * @return bool
   */
  public function getAllowAnySelectedOptionalAttributes()
  {
    return $this->allowAnySelectedOptionalAttributes;
  }


  /**
   * Include seats which have no `optionalAttributes`. Must still have any selected `mandatoryAttribute`
   *
   * @return bool
   */
  public function getAllowNoOptionalAttributes()
  {
    return $this->allowNoOptionalAttributes;
  }


}
