<?php
/**
 * Defines the RawapiRegisterInterestInPerformanceRequest API request object
 *
 * @author    Red61 Ltd
 * @copyright Red61 Ltd
 * @licence   proprietary
 */

namespace Red61\Via\RawGenerated\ApiRequest;

/**
 * This method is used to register/remove a performance interest of a customer if @param interested is true/false.NOTE:
 * local events only
 *
 * [!!] This class is auto-generated from the VIA API documentation and will be overwritten with any new API version.
 *      Do not make any human changes here, those should go in \Red61\Via\ApiRequest\apiRegisterInterestInPerformanceRequest.
 *
 * @package    Red61\Via\RawGenerated\ApiRequest
 * @see        \Red61\Via\ApiRequest\apiRegisterInterestInPerformanceRequest.
 */
abstract class RawapiRegisterInterestInPerformanceRequest
	extends \Red61\Via\ApiRequest\ViaApiRequest
	implements \Red61\Via\ApiRequest\AuthenticatedRequest {


  const SOAP_METHOD_NAME = 'apiRegisterInterestInPerformance';

  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @var int
   */
  protected $customerId;

  /**
   * The serverId and performanceId to list performances in the form "serverId:performanceId"
   *
   * @var string
   */
  protected $performanceRef;

  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @var bool
   */
  protected $interested;

  /**
   * The type of the customer's interest. Please use "Waiting List" for type waiting list in order to be synchronised
   * with the system default
   *
   * @var string
   */
  protected $type;

  /**
   * The optional Note about the type of performance interest
   *
   * @var string
   */
  protected $note;

  /**
   * The authentication code to use.
   *
   * @var string
   */
  protected $webKey;


  /**
   * Create an instance of the class
   *
   * @return static;
   */
  public static function create()
  {
    return new static;
  }

  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @return int
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }


  /**
   * ID representing the customer adding the event to his wish list.
   *
   * @param int $customerId
   *
   * @return $this
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
    return $this;
  }

  /**
   * The serverId and performanceId to list performances in the form "serverId:performanceId"
   *
   * @return string
   */
  public function getPerformanceRef()
  {
    return $this->performanceRef;
  }


  /**
   * The serverId and performanceId to list performances in the form "serverId:performanceId"
   *
   * @param string $performanceRef
   *
   * @return $this
   */
  public function setPerformanceRef($performanceRef)
  {
    $this->performanceRef = $performanceRef;
    return $this;
  }

  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @return bool
   */
  public function getInterested()
  {
    return $this->interested;
  }


  /**
   * boolean indicating whether user wishes to add/remove event from wish list
   *
   * @param bool $interested
   *
   * @return $this
   */
  public function setInterested($interested)
  {
    $this->interested = $interested;
    return $this;
  }

  /**
   * The type of the customer's interest. Please use "Waiting List" for type waiting list in order to be synchronised
   * with the system default
   *
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }


  /**
   * The type of the customer's interest. Please use "Waiting List" for type waiting list in order to be synchronised
   * with the system default
   *
   * @param string $type
   *
   * @return $this
   */
  public function setType($type)
  {
    $this->type = $type;
    return $this;
  }

  /**
   * The optional Note about the type of performance interest
   *
   * @return string
   */
  public function getNote()
  {
    return $this->note;
  }


  /**
   * The optional Note about the type of performance interest
   *
   * @param string $note
   *
   * @return $this
   */
  public function setNote($note)
  {
    $this->note = $note;
    return $this;
  }

  /**
   * The authentication code to use.
   *
   * @return string
   */
  public function getWebKey()
  {
    return $this->webKey;
  }


  /**
   * The authentication code to use.
   *
   * @param string $webKey
   *
   * @return $this
   */
  public function setWebKey($webKey)
  {
    $this->webKey = $webKey;
    return $this;
  }

}
